# Release 22.05 (“Quokka”, 2022.05/30) {#sec-release-22.05}

- Support is planned until the end of December 2022, handing over to 22.11.

## Highlights {#sec-release-22.05-highlights}

In addition to numerous new and upgraded packages, this release has the following highlights:

- Nix has been updated from 2.3 to 2.8. This mainly brings experimental support
  for Flakes, but also marks the `nix` command as experimental which now has to
  be enabled via the configuration explicitly. For more information and
  instructions for upgrades, see the
  release notes for [nix-2.4](https://nixos.org/manual/nix/stable/release-notes/rl-2.4.html),
  [nix-2.5](https://nixos.org/manual/nix/stable/release-notes/rl-2.5.html),
  [nix-2.6](https://nixos.org/manual/nix/stable/release-notes/rl-2.6.html),
  [nix-2.7](https://nixos.org/manual/nix/stable/release-notes/rl-2.7.html) and
  [nix-2.8](https://nixos.org/manual/nix/stable/release-notes/rl-2.8.html)

- The `firefox` browser on `x86_64-linux` now makes use of profile-guided
  optimisation, resulting in a much more responsive browsing experience.

- GNOME has been upgraded to 42. Please take a look at their [Release
  Notes](https://release.gnome.org/42/) for details. In particular, it replaces
  gedit with GNOME Text Editor, GNOME Terminal with GNOME Console (formerly
  King's Cross) and GNOME Screenshot by a tool integrated into the Shell.

- PHP 8.1 is now available.

- systemd services can now set [systemd.services.\<name\>.reloadTriggers](#opt-systemd.services) instead of `reloadIfChanged` for a more granular distinction between reloads and restarts.

- Systemd has been upgraded to the version 250.

- Pulseaudio has been updated to version 15.0 and now optionally
  [supports additional Bluetooth audio codecs](https://www.freedesktop.org/wiki/Software/PulseAudio/Notes/15.0/#supportforldacandaptxbluetoothcodecsplussbcxqsbcwithhigher-qualityparameters)
  such as aptX or LDAC, with codec switching available in `pavucontrol`. This
  feature is disabled by default, but can be enabled with the option
  `hardware.pulseaudio.package = pkgs.pulseaudioFull;`. Existing third-party
  modules that offered similar functions, such as `pulseaudio-modules-bt` or
  `pulseaudio-hsphfpd`, are obsolete and have been removed.

- PostgreSQL now defaults to major version 14.

- Module authors can use `mkRenamedOptionModuleWith` to automate the deprecation cycle without annoying out-of-tree module authors and their users.

- The default GHC version has been updated from 8.10.7 to 9.0.2. `pkgs.haskellPackages` and `pkgs.ghc` will now use this version by default.

- The GNOME and Plasma installation CDs now use `pkgs.calamares` and `pkgs.calamares-nixos-extensions` to allow users to easily install and set up NixOS with a GUI.

- `security.acme.defaults` has been added to simplify the configuration of
  settings for many certificates at once. This also opens up the option to use
  DNS-01 validation when using `enableACME` web server virtual hosts (e.g.
  `services.nginx.virtualHosts.*.enableACME`).

## New Services {#sec-release-22.05-new-services}

- [1password](https://1password.com/), command-lines and graphic interface for 1Password. Available as [programs._1password](#opt-programs._1password.enable) and [programs._1password-gui](#opt-programs._1password.enable).

- [aesmd](https://github.com/intel/linux-sgx#install-the-intelr-sgx-psw), the Intel SGX Architectural Enclave Service Manager. Available as [services.aesmd](#opt-services.aesmd.enable).

- [agate](https://github.com/mbrubeck/agate), a very simple server for the Gemini hypertext protocol. Available as [services.agate](#opt-services.agate.enable).

- [apfs](https://github.com/linux-apfs/linux-apfs-rw), a kernel module for mounting the Apple File System (APFS).

- [argonone](https://gitlab.com/DarkElvenAngel/argononed), a replacement daemon for the Raspberry Pi Argon One power button and cooler. Available at [services.hardware.argonone](options.html#opt-services.hardware.argonone.enable).

- [ArchiSteamFarm](https://github.com/JustArchiNET/ArchiSteamFarm), a C# application with primary purpose of idling Steam cards from multiple accounts simultaneously. Available as [services.archisteamfarm](#opt-services.archisteamfarm.enable).

- [BaGet](https://loic-sharma.github.io/BaGet/), a lightweight NuGet and symbol server. Available at services.baget.

- [bird-lg](https://github.com/xddxdd/bird-lg-go), a BGP looking glass for Bird Routing. Available as [services.bird-lg](#opt-services.bird-lg.package).

- [blocky](https://0xerr0r.github.io/blocky/), fast and lightweight DNS proxy as ad-blocker for local network with many features. Available as [services.blocky](#opt-services.blocky.enable).

- [cloudflare-dyndns](https://github.com/kissgyorgy/cloudflare-dyndns), CloudFlare Dynamic DNS client. Available as [services.cloudflare-dyndns](#opt-services.cloudflare-dyndns.enable).

- [Corosync](https://corosync.github.io/corosync/) and [Pacemaker](https://clusterlabs.org/pacemaker/), A open-source high availability resource manager. Available as [services.corosync](#opt-services.corosync.enable) and [services.pacemaker](#opt-services.pacemaker.enable).

- [create_ap](https://github.com/lakinduakash/linux-wifi-hotspot), a module for creating wifi hotspots using the program linux-wifi-hotspot. Available as [services.create_ap](#opt-services.create_ap.enable).

- [Envoy](https://www.envoyproxy.io/), a high-performance reverse proxy. Available as [services.envoy](#opt-services.envoy.enable).

- [ergochat](https://ergo.chat), a modern IRC with IRCv3 features. Available as [services.ergochat](#opt-services.ergochat.enable).

- [ethercalc](https://github.com/audreyt/ethercalc), an online collaborative spreadsheet. Available as [services.ethercalc](#opt-services.ethercalc.enable).

- [filebeat](https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-overview.html), a lightweight shipper for forwarding and centralizing log data. Available as [services.filebeat](#opt-services.filebeat.enable).

- [FRRouting](https://frrouting.org/), a popular suite of Internet routing protocol daemons (BGP, BFD, OSPF, IS-IS, VRRP and others). Available as [services.frr](#opt-services.frr.babeld.enable).

- [Grafana Mimir](https://grafana.com/oss/mimir/), an open source, horizontally scalable, highly available, multi-tenant, long-term storage for Prometheus. Available as [services.mimir](#opt-services.mimir.enable).

- [Haste](https://hastebin.com/about.md), a pastebin written in node.js. Available as [services.haste](#opt-services.haste-server.enable).

- [headscale](https://github.com/juanfont/headscale), an Open Source implementation of the [Tailscale](https://tailscale.io) Control Server. Available as [services.headscale](#opt-services.headscale.enable).

- [heisenbridge](https://github.com/hifi/heisenbridge), a bouncer-style Matrix IRC bridge. Available as [services.heisenbridge](#opt-services.heisenbridge.enable).

- [https-dns-proxy](https://github.com/aarond10/https_dns_proxy), DNS to DNS over HTTPS (DoH) proxy. Available as [services.https-dns-proxy](#opt-services.https-dns-proxy.enable).

- [input-remapper](https://github.com/sezanzeb/input-remapper), an easy to use tool to change the mapping of your input device buttons. Available at [services.input-remapper](#opt-services.input-remapper.enable).

- [InvoicePlane](https://invoiceplane.com), web application for managing and creating invoices. Available at `services.invoiceplane`.

- [k3b](https://userbase.kde.org/K3b), the KDE disk burning application. Available as [programs.k3b](#opt-programs.k3b.enable).

- [K40-Whisperer](https://www.scorchworks.com/K40whisperer/k40whisperer.html), a program to control cheap Chinese laser cutters. Available as [programs.k40-whisperer.enable](#opt-programs.k40-whisperer.enable). Users must add themselves to the `k40` group to be able to access the device.

- [kanidm](https://kanidm.github.io/kanidm/stable/), an identity management server written in Rust. Available as [services.kanidm](#opt-services.kanidm.enableServer)

- [Maddy](https://maddy.email/), a free an open source mail server. Available as [services.maddy](#opt-services.maddy.enable).

- [matrix-conduit](https://conduit.rs/), a simple, fast and reliable chat server powered by matrix. Available as [services.matrix-conduit](options.html#opt-services.matrix-conduit.enable).

- [Moosefs](https://moosefs.com), fault tolerant petabyte distributed file system. Available as [moosefs](#opt-services.moosefs.master.enable).

- [mozillavpn](https://github.com/mozilla-mobile/mozilla-vpn-client), the client for the [Mozilla VPN](https://vpn.mozilla.org/) service. Available as [services.mozillavpn](#opt-services.mozillavpn.enable).

- [mtr-exporter](https://github.com/mgumz/mtr-exporter), a Prometheus exporter for mtr metrics. Available as [services.mtr-exporter](#opt-services.mtr-exporter.enable).

- [nbd](https://nbd.sourceforge.io/), a Network Block Device server. Available as [services.nbd](#opt-services.nbd.server.enable).

- [netbox](https://github.com/netbox-community/netbox), infrastructure resource modeling (IRM) tool. Available as [services.netbox](#opt-services.netbox.enable).

- [nethoscope](https://github.com/vvilhonen/nethoscope), listen to your network traffic. Available as [programs.nethoscope](#opt-programs.nethoscope.enable).

- [nifi](https://nifi.apache.org), an easy to use, powerful, and reliable system to process and distribute data. Available as [services.nifi](#opt-services.nifi.enable).

- [nix-ld](https://github.com/Mic92/nix-ld), Run unpatched dynamic binaries on NixOS. Available as [programs.nix-ld](#opt-programs.nix-ld.enable).

- [NNCP](http://www.nncpgo.org), NNCP (Node to Node copy) utilities and configuration, Available as [programs.nncp](#opt-programs.nncp.enable).

- [pgadmin4](https://github.com/postgres/pgadmin4), an admin interface for the PostgreSQL database. Available at [services.pgadmin](#opt-services.pgadmin.enable).

- [PowerDNS-Admin](https://github.com/ngoduykhanh/PowerDNS-Admin), a web interface for the PowerDNS server. Available at [services.powerdns-admin](#opt-services.powerdns-admin.enable).

- [prometheus-pve-exporter](https://github.com/prometheus-pve/prometheus-pve-exporter), a tool that exposes information from the Proxmox VE API for use by Prometheus. Available as [services.prometheus.exporters.pve](#opt-services.prometheus.exporters.pve.enable).

- [prosody-filer](https://github.com/ThomasLeister/prosody-filer), a server for handling XMPP HTTP Upload requests. Available at [services.prosody-filer](#opt-services.prosody-filer.enable).

- [Public Inbox](https://public-inbox.org), an "archives first" approach to mailing lists. Available as [services.public-inbox](#opt-services.public-inbox.enable).

- [r53-ddns](https://github.com/fleaz/r53-ddns), a small tool to run your own DDNS service via AWS Route53. Available as [services.r53-ddns](#opt-services.r53-ddns.enable).

- [rmfakecloud](https://ddvk.github.io/rmfakecloud/), a clone of the cloud sync the remarkable tablet. Available as [services.rmfakecloud](#opt-services.rmfakecloud.enable).

- [rootless Docker](https://docs.docker.com/engine/security/rootless/), a `systemd --user` Docker service which runs without root permissions. Available as [virtualisation.docker.rootless.enable](#opt-virtualisation.docker.rootless.enable).

- [rstudio-server](https://www.rstudio.com/products/rstudio/#rstudio-server), a browser-based version of the RStudio IDE for the R programming language. Available as [services.rstudio-server](#opt-services.rstudio-server.enable).

- [mediamtx](https://github.com/aler9/mediamtx), ready-to-use RTSP / RTMP / HLS server and proxy that allows to read, publish and proxy video and audio streams. Available as [services.mediamtx](#opt-services.mediamtx.enable).

- [Snipe-IT](https://snipeitapp.com), a free open source IT asset/license management system. Available as [services.snipe-it](#opt-services.snipe-it.enable).

- [snowflake-proxy](https://snowflake.torproject.org/), a system to defeat internet censorship. Available as [services.snowflake-proxy](#opt-services.snowflake-proxy.enable).

- [sslmate-agent](https://sslmate.com/), a daemon for managing SSL/TLS certificates on a server. Available as [services.sslmate-agent](services.sslmate-agent.enable).

- [starship](https://starship.rs), a minimal, blazing-fast, and infinitely customizable prompt for any shell. Available at [programs.startship](#opt-programs.starship.enable).

- [systembus-notify](https://github.com/rfjakob/systembus-notify), allow system level notifications to reach the users. Available as [services.systembus-notify](opt-services.systembus-notify.enable). Please keep in mind that this service should only be enabled on machines with fully trusted users, as any local user is able to DoS user sessions by spamming notifications.

- [teleport](https://goteleport.com), allows engineers and security professionals to unify access for SSH servers, Kubernetes clusters, web applications, and databases across all environments. Available at [services.teleport](#opt-services.teleport.enable).

- [tetrd](https://tetrd.app), share your internet connection from your device to your PC and vice versa through a USB cable. Available at [services.tetrd](#opt-services.tetrd.enable).

- [uptermd](https://upterm.dev), an open-source solution for sharing terminal sessions instantly over the public internet via secure tunnels. Available at [services.uptermd](#opt-services.uptermd.enable).

- [usbrelayd](https://github.com/darrylb123/usbrelay), an USB Relay MQTT daemon. Available as [services.usbrelayd](#opt-services.usbrelayd.enable).

- [webdav-server-rs](https://github.com/miquels/webdav-server-rs), Webdav server in rust. Available as [services.webdav-server-rs](#opt-services.webdav-server-rs.enable).

- [wg-netmanager](https://github.com/gin66/wg_netmanager), the Wireguard network manager. Available as [services.wg-netmanager](#opt-services.wg-netmanager.enable).

- [Zammad](https://zammad.org/), a web-based, open source user support/ticketing solution. Available as [services.zammad](#opt-services.zammad.enable).

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

## Backward Incompatibilities {#sec-release-22.05-incompatibilities}

- `pkgs.ghc` now refers to `pkgs.targetPackages.haskellPackages.ghc`.
  This _only_ makes a difference if you are cross-compiling and will
  ensure that `pkgs.ghc` always runs on the host platform and compiles
  for the target platform (similar to `pkgs.gcc` for example).
  `haskellPackages.ghc` still behaves as before, running on the build
  platform and compiling for the host platform (similar to `stdenv.cc`).
  This means you don't have to adjust your derivations if you use
  `haskellPackages.callPackage`, but when using `pkgs.callPackage` and
  taking `ghc` as an input, you should now use `buildPackages.ghc`
  instead to ensure cross compilation keeps working (or switch to
  `haskellPackages.callPackage`).

- `pkgs.ghc.withPackages` as well as `haskellPackages.ghcWithPackages` etc.
  now needs be overridden directly, as opposed to overriding the result of
  calling it. Additionally, the `withLLVM` parameter has been renamed to
  `useLLVM`. So instead of `(ghc.withPackages (p: [])).override { withLLVM = true; }`,
  one needs to use `(ghc.withPackages.override { useLLVM = true; }) (p: [])`.

- The update of the haskell package set brings with it a new version of the `xmonad`
  module, which will break your configuration if you use `launch` as entrypoint. The
  example code the corresponding nixos module was adjusted, you may want to have a look at it.

- The `home-assistant` module now requires users that don't want their
  configuration to be managed declaratively to set
  `services.home-assistant.config = null;`. This is required
  due to the way default settings are handled with the new settings style.

  Additionally the default list of `extraComponents` now includes the minimal
  dependencies to successfully complete the [onboarding](https://www.home-assistant.io/getting-started/onboarding/)
  procedure.

- `pkgs.emacsPackages.orgPackages` is removed because org elpa is deprecated.
  The packages in the top level of `pkgs.emacsPackages`, such as org and
  org-contrib, refer to the ones in `pkgs.emacsPackages.elpaPackages` and
  `pkgs.emacsPackages.nongnuPackages` where the new versions will release.

- The configuration and state directories used by `nixos-containers` have been
  moved from `/etc/containers` and `/var/lib/containers` to
  `/etc/nixos-containers` and `/var/lib/nixos-containers`.

  If you are changing `system.stateVersion` to `"22.05"` manually on an existing
  system you are responsible for migrating these directories yourself.

  This is to improve compatibility with `libcontainer` based software such as Podman and Skopeo
  which assumes they have ownership over `/etc/containers`.

- `lib.systems.supported` has been removed, as it was overengineered for determining the systems to support in the nixpkgs flake. The list of systems exposed by the nixpkgs flake can now be accessed as `lib.systems.flakeExposed`.

- For new installations `virtualisation.oci-containers.backend` is now set to `podman` by default.
  If you still want to use Docker on systems where `system.stateVersion` is set to to `"22.05"` set `virtualisation.oci-containers.backend = "docker";`.Old systems with older `stateVersion`s stay with "docker".

- `security.klogd` was removed.  Logging of kernel messages is handled
  by systemd since Linux 3.5.

- `pkgs.ssmtp` has been dropped due to the program being unmaintained.
  `pkgs.msmtp` can be used instead as a substitute `sendmail` implementation.
  The corresponding options `services.ssmtp.*` have been removed as well.
  `programs.msmtp.*` can be used instead for an equivalent setup. For example:

  ```nix
  {
    # Original ssmtp configuration:
    services.ssmtp = {
      enable = true;
      useTLS = true;
      useSTARTTLS = true;
      hostName = "smtp.example:587";
      authUser = "someone";
      authPassFile = "/secrets/password.txt";
    };

    # Equivalent msmtp configuration:
    programs.msmtp = {
      enable = true;
      accounts.default = {
        tls = true;
        tls_starttls = true;
        auth = true;
        host = "smtp.example";
        port = 587;
        user = "someone";
        passwordeval = "cat /secrets/password.txt";
      };
    };
  }
  ```

- `services.kubernetes.addons.dashboard` was removed due to it being an outdated version.

- `services.kubernetes.scheduler.{port,address}` now set `--secure-port` and `--bind-address` instead of `--port` and `--address`, since the former have been deprecated and are no longer functional in kubernetes>=1.23. Ensure that you are not relying on the insecure behaviour before upgrading.

- In the PowerDNS Recursor module (`services.pdns-recursor`), default values of several IP address-related NixOS options have been updated to match the default upstream behavior.
  In particular, Recursor by default will:
    - listen on (and allows connections from) both IPv4 and IPv6 addresses
      (`services.pdns-recursor.dns.address`, `services.pdns-recursor.dns.allowFrom`);
    - allow only local connections to the REST API server (`services.pdns-recursor.api.allowFrom`).

- In the ncdns module, the default value of `services.ncdns.address` has been changed to the IPv6 loopback address (`::1`).

- `openldap` (and therefore the slapd LDAP server) were updated to version 2.6.2. The project introduced backwards-incompatible changes, namely the removal of the bdb, hdb, ndb, and shell backends in slapd. Therefore before updating, dump your database `slapcat -n 1` in LDIF format, and reimport it after updating your `services.openldap.settings`, which represents your `cn=config`.

  Additionally with 2.5 the argon2 module was included in the standard distribution and renamed from `pw-argon2` to `argon2`. Remember to update your `olcModuleLoad` entry in `cn=config`.

- `openssh` has been update to 8.9p1, changing the FIDO security key middleware interface.

- `git` no longer hardcodes the path to openssh' ssh binary to reduce the amount of rebuilds. If you are using git with ssh remotes and do not have a ssh binary in your environment consider adding `openssh` to it or switching to `gitFull`.

- `services.k3s.enable` no longer implies `systemd.enableUnifiedCgroupHierarchy = false`, and will default to the 'systemd' cgroup driver when using `services.k3s.docker = true`.
  This change may require a reboot to take effect, and k3s may not be able to run if the boot cgroup hierarchy does not match its configuration.
  The previous behavior may be retained by explicitly setting `systemd.enableUnifiedCgroupHierarchy = false` in your configuration.

- `fonts.fonts` no longer includes ancient bitmap fonts when both `config.services.xserver.enable` and `config.nixpkgs.config.allowUnfree` are enabled.
  If you still want these fonts, use:

  ```nix
  {
    fonts.fonts = [
      pkgs.xorg.fontbhlucidatypewriter100dpi
      pkgs.xorg.fontbhlucidatypewriter75dpi
      pkgs.xorg.fontbh100dpi
    ];
  }
  ```

- `services.prometheus.alertManagerTimeout` has been removed as it has been deprecated upstream and has no effect.

- The DHCP server (`services.dhcpd4`, `services.dhcpd6`) has been hardened.
  The service is now using the systemd's `DynamicUser` mechanism to run as an unprivileged dynamically-allocated user with limited capabilities.
  The dhcpd state files are now always stored in `/var/lib/dhcpd{4,6}` and the `services.dhcpd4.stateDir` and `service.dhcpd6.stateDir` options have been removed.
  If you were depending on root privileges or set{uid,gid,cap} binaries in dhcpd shell hooks, you may give dhcpd more capabilities with e.g. `systemd.services.dhcpd6.serviceConfig.AmbientCapabilities`.

- The `mailpile` email webclient (`services.mailpile`) has been removed due to its reliance on python2.

- `services.ipfs.extraFlags` is now escaped with `utils.escapeSystemdExecArgs`. If you rely on systemd interpolating `extraFlags` in the service `ExecStart`, this will no longer work.

- `hbase` version 0.98.24 has been removed. The package now defaults to version 2.4.11. Versions 1.7.1 and 3.0.0-alpha-2 are also available.

- `services.paperless-ng` was renamed to `services.paperless`. Accordingly, the `paperless-ng-manage` script (located in `dataDir`) was renamed to `paperless-manage`. `services.paperless` now uses `paperless-ngx`.

- The `matrix-synapse` service (`services.matrix-synapse`) has been converted to use the `settings` option defined in RFC42.
  This means that options that are part of your `homeserver.yaml` configuration, and that were specified at the top-level of the
  module (`services.matrix-synapse`) now need to be moved into `services.matrix-synapse.settings`. And while not all options you
  may use are defined in there, they are still supported, because you can set arbitrary values in this freeform type.

  The `listeners.*.bind_address` option was renamed to `bind_addresses` in order to match the upstream `homeserver.yaml` option
  name. It is now also a list of strings instead of a string.

  An example to make the required migration clearer:

  Before:
  ```nix
  {
    services.matrix-synapse = {
      enable = true;

      server_name = "example.com";
      public_baseurl = "https://example.com:8448";

      enable_registration = false;
      registration_shared_secret = "xohshaeyui8jic7uutuDogahkee3aehuaf6ei3Xouz4iicie5thie6nohNahceut";
      macaroon_secret_key = "xoo8eder9seivukaiPh1cheikohquuw8Yooreid0The4aifahth3Ou0aiShaiz4l";

      tls_certificate_path = "/var/lib/acme/example.com/fullchain.pem";
      tls_certificate_path = "/var/lib/acme/example.com/fullchain.pem";

      listeners = [
        {
          port = 8448;
          bind_address = "";
          type = "http";
          tls = true;
          resources = [
            {
              names = [ "client" ];
              compress = true;
            }
            {
              names = [ "federation" ];
              compress = false;
            }
          ];
        }
      ];

    };
  }
  ```

  After:
  ```nix
  {
    services.matrix-synapse = {
      enable = true;

      # this attribute set holds all values that go into your homeserver.yaml configuration
      # See https://github.com/matrix-org/synapse/blob/develop/docs/sample_config.yaml for
      # possible values.
      settings = {
        server_name = "example.com";
        public_baseurl = "https://example.com:8448";

        enable_registration = false;
        # pass `registration_shared_secret` and `macaroon_secret_key` via `extraConfigFiles` instead

        tls_certificate_path = "/var/lib/acme/example.com/fullchain.pem";
        tls_certificate_path = "/var/lib/acme/example.com/fullchain.pem";

        listeners = [
          {
            port = 8448;
            bind_addresses = [
              "::"
              "0.0.0.0"
            ];
            type = "http";
            tls = true;
            resources = [
              {
                names = [ "client" ];
                compress = true;
              }
              {
                names = [ "federation" ];
                compress = false;
              }
            ];
          }
        ];
      };

      extraConfigFiles = [ "/run/keys/matrix-synapse/secrets.yaml" ];
    };
  }
  ```

  The secrets in your original config should be migrated into a YAML file that is included via `extraConfigFiles`. The filename must be quoted to prevent nix from copying it to the (world readable) store.

  Additionally a few option defaults have been synced up with upstream default values, for example the `max_upload_size` grew from `10M` to `50M`. For the same reason, the default
  `media_store_path` was changed from `${dataDir}/media` to `${dataDir}/media_store` if `system.stateVersion` is at least `22.05`. Files will need to be manually moved to the new
  location if the `stateVersion` is updated.

  As of Synapse 1.58.0, the old groups/communities feature has been disabled by default. It will be completely removed with Synapse 1.61.0.

- The Keycloak package (`pkgs.keycloak`) has been switched from the
  Wildfly version, which will soon be deprecated, to the Quarkus based
  version. The Keycloak service (`services.keycloak`) has been updated
  to accommodate the change and now differs from the previous version
  in a few ways:

  - `services.keycloak.extraConfig` has been removed in favor of the
    new [settings-style](https://github.com/NixOS/rfcs/blob/master/rfcs/0042-config-option.md)
    [`services.keycloak.settings`](#opt-services.keycloak.settings)
    option. The available options correspond directly to parameters in
    `conf/keycloak.conf`. Some of the most important parameters are
    documented as suboptions, the rest can be found in the [All
    configuration section of the Keycloak Server Installation and
    Configuration
    Guide](https://www.keycloak.org/server/all-config). While the new
    configuration is much simpler and cleaner than the old JBoss CLI
    one, this unfortunately mean that there's no straightforward way
    to convert an old configuration to the new format and some
    settings may not even be available anymore.

  - `services.keycloak.frontendUrl` was removed and the frontend URL
    is now configured through the `hostname` family of settings in
    [`services.keycloak.settings`](#opt-services.keycloak.settings)
    instead. See the [Hostname section of the Keycloak Server
    Installation and Configuration
    Guide](https://www.keycloak.org/server/hostname) for more
    details. Additionally, `/auth` was removed from the default
    context path and needs to be added back in
    [`services.keycloak.settings.http-relative-path`](#opt-services.keycloak.settings.http-relative-path)
    if you want to keep compatibility with your current clients.

  - `services.keycloak.bindAddress`,
    `services.keycloak.forceBackendUrlToFrontendUrl`,
    `services.keycloak.httpPort` and `services.keycloak.httpsPort`
    have been removed in favor of their equivalent options in
    [`services.keycloak.settings`](#opt-services.keycloak.settings). `httpPort`
    and `httpsPort` have additionally had their types changed from
    `str` to `port`.

    The new names are as follows:
    - `bindAddress`: [`services.keycloak.settings.http-host`](#opt-services.keycloak.settings.http-host)
    - `forceBackendUrlToFrontendUrl`: `services.keycloak.settings.hostname-strict-backchannel`
    - `httpPort`: [`services.keycloak.settings.http-port`](#opt-services.keycloak.settings.http-port)
    - `httpsPort`: [`services.keycloak.settings.https-port`](#opt-services.keycloak.settings.https-port)

  For example, when using a reverse proxy the migration could look
  like this:

  Before:
  ```nix
  {
    services.keycloak = {
      enable = true;
      httpPort = "8080";
      frontendUrl = "https://keycloak.example.com/auth";
      database.passwordFile = "/run/keys/db_password";
      extraConfig = {
        "subsystem=undertow"."server=default-server"."http-listener=default".proxy-address-forwarding =
          true;
      };
    };
  }
  ```

  After:
  ```nix
  {
    services.keycloak = {
      enable = true;
      settings = {
        http-port = 8080;
        hostname = "keycloak.example.com";
        http-relative-path = "/auth";
        proxy = "edge";
      };
      database.passwordFile = "/run/keys/db_password";
    };
  }
  ```

- The MoinMoin wiki engine (`services.moinmoin`) has been removed, because Python 2 is being retired from nixpkgs.

- Services in the `hadoop` module previously set `openFirewall` to true by default.
  This has now been changed to false. Node definitions for multi-node clusters would need
  `openFirewall = true;` to be added to to hadoop services when upgrading from NixOS 21.11.

- `services.hadoop.yarn.nodemanager` now uses cgroup-based CPU limit enforcement by default.
  Additionally, the option `useCGroups` was added to nodemanagers as an easy way to switch
  back to the old behavior.

- The `wafHook` hook now honors `NIX_BUILD_CORES` when `enableParallelBuilding` is not set explicitly. Packages can restore the old behaviour by setting `enableParallelBuilding=false`.

- `pkgs.claws-mail-gtk2`, representing Claws Mail's older release version three, was removed in order to get rid of Python 2.
  Please switch to `claws-mail`, which is Claws Mail's latest release based on GTK+3 and Python 3.

- The `writers.writePython2` and corresponding `writers.writePython2Bin` convenience functions to create executable Python 2 scripts in the store were removed in preparation of removal of the Python 2 interpreter.
  Scripts have to be converted to Python 3 for use with `writers.writePython3` or `writers.writePyPy2` needs to be used.

- `buildGoModule` was updated to use `go_1_17`, third party derivations that specify >= go 1.17 in the main `go.mod` will need to regenerate their `vendorSha256` hash.

- The `gnome-passwordsafe` package updated to [version 6.x](https://gitlab.gnome.org/World/secrets/-/tags/6.0) and renamed to `gnome-secrets`.

- `services.gnome.experimental-features.realtime-scheduling` option has been removed, as GNOME Shell now [uses rtkit](https://gitlab.gnome.org/GNOME/mutter/-/merge_requests/2060). Use `security.rtkit.enable = true;` instead. As before, you will need to have it enabled using GSettings.

- `services.telepathy` will no longer be enabled by default for GNOME desktops, one should enable it in their configs if using Empathy or Polari.

- If you previously used `/etc/docker/daemon.json`, you need to incorporate the changes into the new option `virtualisation.docker.daemon.settings`.

- Ntopng (`services.ntopng`) is updated to 5.2.1 and uses a separate Redis instance if `system.stateVersion` is at least `22.05`. Existing setups shouldn't be affected.

- The backward compatibility in `services.wordpress` to configure sites with
  the old interface has been removed. Please use `services.wordpress.sites`
  instead.

- The backward compatibility in `services.dokuwiki` to configure sites with the
  old interface has been removed. Please use `services.dokuwiki.sites` instead.

- opensmtpd-extras is no longer build with python2 scripting support due to python2 deprecation in nixpkgs

- `services.miniflux.adminCredentialFiles` is now required, instead of defaulting to `admin` and `password`.

- The `taskserver` module no longer implicitly opens ports in the firewall
  configuration. This is now controlled through the option
  `services.taskserver.openFirewall`.

- The `autorestic` package has been upgraded from 1.3.0 to 1.5.0 which introduces breaking changes in config file, check [their migration guide](https://autorestic.vercel.app/migration/1.4_1.5) for more details.

- `teleport` has been upgraded to major version 9. Please see upstream [upgrade instructions](https://goteleport.com/docs/setup/operations/upgrading/) and [release notes](https://goteleport.com/docs/changelog/#900).

- For `pkgs.python3.pkgs.ipython`, its direct dependency `pkgs.python3.pkgs.matplotlib-inline`
  (which is really an adapter to integrate matplotlib in ipython if it is installed) does
  not depend on `pkgs.python3.pkgs.matplotlib` anymore.
  This is closer to a non-Nix install of ipython.
  This has the added benefit to reduce the closure size of `ipython` from ~400MB to ~160MB
  (including ~100MB for python itself).

- `documentation.man` has been refactored to support choosing a man implementation other than GNU's `man-db`. For this, `documentation.man.manualPages` has been renamed to `documentation.man.man-db.manualPages`. If you want to use the new alternative man implementation `mandoc`, add `documentation.man = { enable = true; man-db.enable = false; mandoc.enable = true; }` to your configuration.

- Normal users (with `isNormalUser = true`) which have non-empty `subUidRanges` or `subGidRanges` set no longer have additional implicit ranges allocated. To enable automatic allocation back set `autoSubUidGidRange = true`.

- `idris2` now requires `--package` when using packages `contrib` and `network`, while previously these idris2 packages were automatically loaded.

- The iputils package, which is installed by default, no longer provides the
  legacy tools `tftpd` and `traceroute6`. More tools (`ninfod`, `rarpd`, and
  `rdisc`) are going to be removed in the next release. See
  [upstream's release notes](https://github.com/iputils/iputils/releases/tag/20211215)
  for more details and available replacements.

- `services.thelounge.private` was removed in favor of `services.thelounge.public`, to follow with upstream changes.

- `pkgs.docbookrx` was removed since it's unmaintained

- `pkgs._7zz` is now correctly licensed as LGPL3+ and BSD3 with optional unfree unRAR licensed code

- The `vim.customize` function produced by `vimUtils.makeCustomizable` now has a slightly different interface:
  * The wrapper now includes everything in the given Vim derivation if `name` is `"vim"` (the default). This makes the `wrapManual` argument obsolete, but this behavior can be overridden by setting the `standalone` argument.
  * All the executables present in the given derivation (or, in `standalone` mode, only the `*vim` ones) are wrapped. This makes the `wrapGui` argument obsolete.
  * The `vimExecutableName` and `gvimExecutableName` arguments were replaced by a single `executableName` argument in which the shell variable `$exe` can be used to refer to the wrapped executable's name.

  See the comments in `pkgs/applications/editors/vim/plugins/vim-utils.nix` for more details.

  `vimUtils.vimWithRC` was removed. You should instead use `customize` on a Vim derivation, which now accepts `vimrcFile` and `gvimrcFile` arguments.

- `tilp2` was removed together with its module

- The F-PROT antivirus (`fprot` package) and its service module were removed because it
  reached [end-of-life](https://kb.cyren.com/av-support/index.php?/Knowledgebase/Article/View/434/0/end-of-sale--end-of-life-for-f-prot-and-csam).

- `bird1` and its modules `services.bird` as well as `services.bird6` have been removed. Upgrade to `services.bird2`.

- The options `networking.interfaces.<name>.ipv4.routes` and `networking.interfaces.<name>.ipv6.routes` are no longer ignored when using networkd instead of the default scripted network backend by setting `networking.useNetworkd` to `true`.

- The `miller` package has been upgraded from 5.10.3 to [6.2.0](https://github.com/johnkerl/miller/releases/tag/v6.2.0). See [What's new in Miller 6](https://miller.readthedocs.io/en/latest/new-in-miller-6).

- MultiMC has been replaced with the fork PrismLauncher due to upstream
  developers being hostile to 3rd party package maintainers. PrismLauncher
  removes all MultiMC branding and is aimed at providing proper 3rd party
  packages like the one contained in Nixpkgs. This change affects the data
  folder where game instances and other save and configuration files are stored.
  Users with existing installations should rename `~/.local/share/multimc` to
  `~/.local/share/PrismLauncher`. The main config file's path has also moved
  from `~/.local/share/multimc/multimc.cfg` to
  `~/.local/share/PrismLauncher/prismlauncher.cfg`.

- `systemd-nspawn@.service` settings have been reverted to the default systemd behaviour. User namespaces are now activated by default. If you want to keep running nspawn containers without user namespaces you need to set `systemd.nspawn.<name>.execConfig.PrivateUsers = false`

- `systemd-shutdown` is now properly linked on shutdown to unmount all filesystems and device mapper devices cleanly. This can be disabled using `systemd.shutdownRamfs.enable`.

- The Tor SOCKS proxy is now actually disabled if `services.tor.client.enable` is set to `false` (the default). If you are using this functionality but didn't change the setting or set it to `false`, you now need to set it to `true`.

- `services.github-runner` has been hardened.  Notably address families and
  system calls have been restricted, which may adversely affect some kinds of
  testing, e.g. using `AF_BLUETOOTH` to test bluetooth devices.

- The terraform 0.12 compatibility has been removed and the `terraform.withPlugins` and `terraform-providers.mkProvider` implementations simplified. Providers now need to be stored under
`$out/libexec/terraform-providers/<registry>/<owner>/<name>/<version>/<os>_<arch>/terraform-provider-<name>_v<version>` (which mkProvider does).

  This breaks back-compat so it's not possible to mix-and-match with previous versions of nixpkgs. In exchange, it now becomes possible to use the providers from [nixpkgs-terraform-providers-bin](https://github.com/numtide/nixpkgs-terraform-providers-bin) directly.

- The `dendrite` package has been upgraded from 0.5.1 to
  [0.6.5](https://github.com/matrix-org/dendrite/releases/tag/v0.6.5). Instances
  configured with split sqlite databases, which has been the default
  in NixOS, require merging of the federation sender and signing key
  databases. See upstream [release
  notes](https://github.com/matrix-org/dendrite/releases/tag/v0.6.0)
  on version 0.6.0 for details on database changes.

- The existing `pkgs.opentelemetry-collector` has been moved to
  `pkgs.opentelemetry-collector-contrib` to match the actual source being the
  "contrib" edition. `pkgs.opentelemetry-collector` is now the actual core
  release of opentelemetry-collector. If you use the community contributions
  you should change the package you refer to. If you don't need them update your
  commands from `otelcontribcol` to `otelcorecol` and enjoy a 7x smaller binary.

- `services.zookeeper` has a new option `jre` for specifying the JRE to start
  zookeeper with. It defaults to the JRE that `pkgs.zookeeper` was wrapped with,
  instead of `pkgs.jre`. This changes the JRE to `pkgs.jdk11_headless` by default.

- `pkgs.pgadmin` now refers to `pkgs.pgadmin4`. `pgadmin3` has been removed.

- `pkgs.minetestclient_4` and `pkgs.minetestserver_4` have been removed, as the last 4.x release was in 2018. `pkgs.minetestclient` (equivalent to `pkgs.minetest` ) and `pkgs.minetestserver` can be used instead.

- `pkgs.noto-fonts-cjk` is now deprecated in favor of `pkgs.noto-fonts-cjk-sans`
  and `pkgs.noto-fonts-cjk-serif` because they each have different release
  schedules. To maintain compatibility with prior releases of Nixpkgs,
  `pkgs.noto-fonts-cjk` is currently an alias of `pkgs.noto-fonts-cjk-sans` and
  doesn't include serif fonts.

- `pkgs.epgstation` has been upgraded from v1 to v2, resulting in incompatible
  changes in the database scheme and configuration format.

- Some top-level settings under [services.epgstation](#opt-services.epgstation.enable)
  is now deprecated because it was redundant due to the same options being
  present in [services.epgstation.settings](#opt-services.epgstation.settings).

- The option `services.epgstation.basicAuth` was removed because basic
  authentication support was dropped by upstream.

- The option [services.epgstation.database.passwordFile](#opt-services.epgstation.database.passwordFile)
  no longer has a default value. Make sure to set this option explicitly before
  upgrading. Change the database password if necessary.

- The [services.epgstation.settings](#opt-services.epgstation.settings)
  option now expects options for `config.yml` in EPGStation v2.

- Existing data for the [services.epgstation](#opt-services.epgstation.enable)
  module would have to be backed up prior to the upgrade. To back up existing
  data to `/tmp/epgstation.bak`, run
  `sudo -u epgstation epgstation run backup /tmp/epgstation.bak`.
  To import that data after to the upgrade, run
  `sudo -u epgstation epgstation run v1migrate /tmp/epgstation.bak`

- `switch-to-configuration` (the script that is run when running `nixos-rebuild switch` for example) has been reworked
    * The interface that allows activation scripts to restart units has been streamlined. Restarting and reloading is now done by a single file `/run/nixos/activation-restart-list` that honors `restartIfChanged` and `reloadIfChanged` of the units.
        * Preferring to reload instead of restarting can still be achieved using `/run/nixos/activation-reload-list`.
    * The script now uses a proper ini-file parser to parse systemd units. Some values are now only searched in one section instead of in the entire unit. This is only relevant for units that don't use the NixOS systemd moule.
        * `RefuseManualStop`, `X-OnlyManualStart`, `X-StopOnRemoval`, `X-StopOnReconfiguration` are only searched in the `[Unit]` section
        * `X-ReloadIfChanged`, `X-RestartIfChanged`, `X-StopIfChanged` are only searched in the `[Service]` section

- The `services.bookstack.cacheDir` option has been removed, since the
  cache directory is now handled by systemd.

- The `services.bookstack.extraConfig` option has been replaced by
  `services.bookstack.config` which implements a
  [settings-style](https://github.com/NixOS/rfcs/blob/master/rfcs/0042-config-option.md)
  configuration.

- `lib.assertMsg` and `lib.assertOneOf` no longer return `false` if the passed condition is `false`, `throw`ing the given error message instead (which makes the resulting error message less cluttered). This will not impact the behaviour of code using these functions as intended, namely as top-level wrapper for `assert` conditions.

- The `vpnc` package has been changed to use GnuTLS instead of OpenSSL by default for licensing reasons.

- The default version of `nextcloud` is **nextcloud24**. Please note that it's **not** possible to upgrade
  `nextcloud` across multiple major versions! This means it's e.g. not possible to upgrade from `nextcloud22`
  to `nextcloud24` in a single deploy and most `21.11` users will have to upgrade to `nextcloud23` first.

- `pkgs.vimPlugins.onedark-nvim` now refers to [navarasu/onedark.nvim](https://github.com/navarasu/onedark.nvim)
  (formerly refers to [olimorris/onedarkpro.nvim](https://github.com/olimorris/onedarkpro.nvim)).

- `services.pipewire.enable` will default to enabling the WirePlumber session manager instead of pipewire-media-session.
  pipewire-media-session is deprecated by upstream and not recommended, but can still be manually enabled by setting
  `services.pipewire.media-session.enable` to `true` and `services.pipewire.wireplumber.enable` to `false`.

- `pkgs.makeDesktopItem` has been refactored to provide a more idiomatic API. Specifically:
  - All valid options as of FDO Desktop Entry specification version 1.4 can now be passed in as explicit arguments
  - `exec` can now be null, for entries that are not of type Application
  - `mimeType` argument is renamed to `mimeTypes` for consistency
  - `mimeTypes`, `categories`, `implements`, `keywords`, `onlyShowIn` and `notShowIn` take lists of strings instead of one string with semicolon separators
  - `extraDesktopEntries` renamed to `extraConfig` for consistency
  - Actions should now be provided as an attrset `actions`, the `Actions` line will be autogenerated.
  - `extraEntries` is removed.
  - Additional validation is added both at eval time and at build time.

  See the `vscode` package for a more detailed example.

- Existing `resholve*` functions have been renamed and nested under `pkgs.resholve`. Update uses to:
  - `resholvePackage` -> `resholve.mkDerivation`
  - `resholveScript` -> `resholve.writeScript`
  - `resholveScriptBin` -> `resholve.writeScriptBin`

- `pkgs.cosmopolitan` no longer provides the `cosmoc` command. It has been moved to `pkgs.cosmoc`.

- `pkgs.graalvmXX-ce` packages no longer provide support for Python/Ruby/WASM, instead focusing only in Java and Native Image Support. If you need to add support back, please see the `pkgs.graalvmCEPackages.mkGraal` function to create your own customized version of GraalVM with support for what you need.

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

## Other Notable Changes {#sec-release-22.05-notable-changes}

- The option [services.redis.servers](#opt-services.redis.servers) was added
  to support per-application `redis-server` which is more secure since Redis databases
  are only mere key prefixes without any configuration or ACL of their own.
  Backward-compatibility is preserved by mapping old `services.redis.settings`
  to `services.redis.servers."".settings`, but you are strongly encouraged
  to name each `redis-server` instance after the application using it,
  instead of keeping that nameless one.
  Except for the nameless `services.redis.servers.""`
  still accessible at `127.0.0.1:6379`,
  and to the members of the Unix group `redis`
  through the Unix socket `/run/redis/redis.sock`,
  all other `services.redis.servers.${serverName}`
  are only accessible by default
  to the members of the Unix group `redis-${serverName}`
  through the Unix socket `/run/redis-${serverName}/redis.sock`.

- The option [virtualisation.vmVariant](#opt-virtualisation.vmVariant) was added
  to allow users to make changes to the `nixos-rebuild build-vm` configuration
  that do not apply to their normal system.

  The `config.system.build.vm` attribute now always exists and defaults to the
  value from `vmVariant`. Configurations that import the `virtualisation/qemu-vm.nix`
  module themselves will override this value, such that `vmVariant` is not used.

  Similarly [virtualisation.vmVariantWithBootloader](#opt-virtualisation.vmVariantWithBootLoader) was added.

- The configuration portion of the `nix-daemon` module has been reworked and exposed as [nix.settings](options.html#opt-nix-settings):
  * Legacy options have been mapped to the corresponding options under [nix.settings](options.html#opt-nix.settings) and will be deprecated when NixOS 21.11 reaches end of life.
  * [nix.buildMachines.publicHostKey](options.html#opt-nix.buildMachines.publicHostKey) has been added.

- [`kops`](https://kops.sigs.k8s.io) defaults to 1.23.2, which will enable [Instance Metadata Service Version 2](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-service.html) and require tokens on new clusters with Kubernetes >= 1.22. This will increase security by default, but may break some types of workloads. The default behaviour for `spec.kubeDNS.nodeLocalDNS.forwardToKubeDNS` has changed from `true` to `false`. Cilium now has `disable-cnp-status-updates: true` by default. Set this to false if you rely on the CiliumNetworkPolicy status fields. Support for Kubernetes 1.17, the Lyft CNI, Weave CNI on Kubernetes >= 1.23, CentOS 7 and 8, Debian 9, RHEL 7, and Ubuntu 16.05 (Xenial) has been removed. See the [1.22 release notes](https://kops.sigs.k8s.io/releases/1.22-notes/) and [1.23 release notes](https://kops.sigs.k8s.io/releases/1.23-notes/) for more details, including other significant changes.

- Mattermost has been upgraded to extended support version 6.3 as the previously
  packaged extended support version 5.37 is [reaching end of life](https://docs.mattermost.com/upgrade/extended-support-release.html).
  Migration may take some time, see the [changelog](https://docs.mattermost.com/install/self-managed-changelog.html#release-v6-3-extended-support-release)
  and [important upgrade notes](https://docs.mattermost.com/upgrade/important-upgrade-notes.html).

- The `writers.writePyPy2`/`writers.writePyPy3` and corresponding `writers.writePyPy2Bin`/`writers.writePyPy3Bin` convenience functions to create executable Python 2/3 scripts using the PyPy interpreter were added.

- Some improvements have been made to the `hadoop` module:
  - A `gatewayRole` option has been added, for deploying hadoop cluster configuration files to a node that does not have any active services
  - Support for older versions of hadoop have been added to the module
  - Overriding and extending site XML files has been made easier

- The auto-upgrade service now accepts persistent (default: true) parameter.
  By default auto-upgrade will now run immediately if it would have been triggered at least
  once during the time when the timer was inactive.

- Mastodon now uses `services.redis.servers` to start a new redis server, instead of using a global redis server.
  This improves compatibility with other services that use redis.

  Note that this will recreate the redis database, although according to the [Mastodon docs](https://docs.joinmastodon.org/admin/backups/),
  this is almost harmless:
  > Losing the Redis database is almost harmless: The only irrecoverable data will be the contents of the Sidekiq queues and scheduled retries of previously failed jobs.
  >  The home and list feeds are stored in Redis, but can be regenerated with tootctl.

  If you do want to save the redis database, you can use the following commands:
  ```bash
  redis-cli save
  cp /var/lib/redis/dump.rdb "/var/lib/redis-mastodon/dump.rdb"
  ```
- Peertube now uses services.redis.servers to start a new redis server, instead of using a global redis server.
  This improves compatibility with other services that use redis.

  Redis database is used for storage only cache and job queue. More information can be found here - [Peertube architecture](https://docs.joinpeertube.org/contribute-architecture).

  If you do want to save the redis database, you can use the following commands before upgrade OS:
  ```bash
  redis-cli save
  sudo mkdir /var/lib/redis-peertube
  sudo cp /var/lib/redis/dump.rdb /var/lib/redis-peertube/dump.rdb
  ```
- Added the `keter` NixOS module. Keter reverse proxies requests to your loaded application based on virtual hostnames.

- If you are using Wayland you can choose to use the Ozone Wayland support
  in Chrome and several Electron apps by setting the environment variable
  `NIXOS_OZONE_WL=1` (for example via
  `environment.sessionVariables.NIXOS_OZONE_WL = "1"`).
  This is not enabled by default because Ozone Wayland is
  still under heavy development and behavior is not always flawless.
  Furthermore, not all Electron apps use the latest Electron versions.

- A new option group `systemd.network.wait-online` was added, with options to configure `systemd-networkd-wait-online.service`:
  - `anyInterface` allows specifying that the network should be considered online when *at least one* interface is online (useful on laptops)
  - `timeout` defines how long to wait for the network to come online
  - `extraArgs` for everything else

- The `influxdb2` package was split into `influxdb2-server` and
  `influxdb2-cli`, matching the split that took place upstream. A
  combined `influxdb2` package is still provided in this release for
  backwards compatibility, but will be removed at a later date.

- The `unifi` package was switched from `unifi6` to `unifi7`.
  Direct downgrades from Unifi 7 to Unifi 6 are not possible and require restoring from a backup made by Unifi 6.

- `programs.zsh.autosuggestions.strategy` now takes a list of strings instead of a string.

- The `asterisk` and `asterisk-stable` packages were switched from `asterisk_18` to the newly-packaged `asterisk_19`. Asterisk 13 and 17 have been removed as they have reached their end of life.

- The `services.unifi.openPorts` option default value of `true` is now deprecated and will be changed to `false` in 22.11.
  Configurations using this default will print a warning when rebuilt.

- The `services.unifi-video.openPorts` option default value of `true` is now deprecated and will be changed to `false` in 22.11.
  Configurations using this default will print a warning when rebuilt.

- `security.acme` certificates will now correctly check for CA
  revocation before reaching their minimum age.

- Removing domains from `security.acme.certs._name_.extraDomainNames`
  will now correctly remove those domains during rebuild/renew.

- MariaDB is now offered in several versions, not just the newest one.
  So if you have a need for running MariaDB 10.4 for example, you can now just set `services.mysql.package = pkgs.mariadb_104;`.
  In general, it is recommended to run the newest version, to get the newest features, while sticking with an LTS version will most likely provide a more stable experience.
  Sometimes software is also incompatible with the newest version of MariaDB.

- The option
  [programs.ssh.enableAskPassword](#opt-programs.ssh.enableAskPassword) was
  added, decoupling the setting of `SSH_ASKPASS` from
  `services.xserver.enable`. This allows easy usage in non-X11 environments,
  e.g. Wayland.

- [programs.ssh.knownHosts](#opt-programs.ssh.knownHosts) has gained an `extraHostNames`
  option to augment `hostNames`. It is now possible to use the attribute name of a `knownHosts`
  entry as the primary host name and specify secondary host names using `extraHostNames` without
  having to duplicate the primary host name.

- The `services.stubby` module was converted to a [settings-style](https://github.com/NixOS/rfcs/blob/master/rfcs/0042-config-option.md) configuration.

- The option
  [services.xserver.desktopManager.runXdgAutostartIfNone](#opt-services.xserver.desktopManager.runXdgAutostartIfNone)
  was added in order to automatically run XDG autostart files for sessions without a desktop manager.
  This replaces helpers like the `dex` package.

- When setting [i18n.inputMethod.enabled](#opt-i18n.inputMethod.enabled) to `fcitx5`,
  it no longer creates corresponding systemd user services.
  It now relies on XDG autostart files to start and work properly in your desktop sessions.
  If you are using only a window manager without a desktop manager, you need to enable
  `services.xserver.desktopManager.runXdgAutostartIfNone` or using the `dex` package to make `fcitx5` work.


- The option `services.duplicati.dataDir` has been added to allow changing the location of duplicati's files.

- The options `boot.extraModprobeConfig` and `boot.blacklistedKernelModules` now also take effect in the initrd by copying the file `/etc/modprobe.d/nixos.conf` into the initrd.

- `nixos-generate-config` now puts the dhcp configuration in `hardware-configuration.nix` instead of `configuration.nix`.

- ORY Kratos was updated to version 0.9.0-alpha.3, which introduces some breaking changes:
  - All endpoints at the Admin API are now exposed at `/admin/`. For example, endpoint `https://kratos:4434/identities` is now exposed at `https://kratos:4434/admin/identities`
  - Configuration key `selfservice.whitelisted_return_urls` has been renamed to `allowed_return_urls`
  - The `password_identifier` form field of the password login strategy has been renamed to `identifier` to make compatibility with passwordless flows possible.
  - Instead of having a global `default_schema_url` which developers used to update their schema, you now need to define the `default_schema_id` which must reference schema ID in your config.
  - Calling `/self-service/recovery` without flow ID or with an invalid flow ID while authenticated will now respond with an error instead of redirecting to the default page.
  - If you are relying on the SQLite images, update your Docker Pull commands as follows:
    - `docker pull oryd/kratos:{version}`
  - Additionally, all passwords now have to be at least 8 characters long.
  - For more details, see:
    - [Release Notes for v0.8.1-alpha-1](https://github.com/ory/kratos/releases/tag/v0.8.1-alpha.1)
    - [Release Notes for v0.8.2-alpha-1](https://github.com/ory/kratos/releases/tag/v0.8.2-alpha.1)
    - [Release Notes for v0.9.0-alpha-1](https://github.com/ory/kratos/releases/tag/v0.9.0-alpha.1)
    - [Release Notes for v0.9.0-alpha-3](https://github.com/ory/kratos/releases/tag/v0.9.0-alpha.3)


- `fetchFromSourcehut` now allows fetching repositories recursively
  using `fetchgit` or `fetchhg` if the argument `fetchSubmodules`
  is set to `true`.

- A module for declarative configuration of openconnect VPN profiles was added under `networking.openconnect`.

- The `element-desktop` package now has an `useKeytar` option (defaults to `true`),
  which allows disabling `keytar` and in turn `libsecret` usage
  (which binds to native credential managers / keychain libraries).

- The option `services.thelounge.plugins` has been added to allow installing plugins for The Lounge. Plugins can be found in `pkgs.theLoungePlugins.plugins` and `pkgs.theLoungePlugins.themes`.

- The option `services.xserver.videoDriver = [ "nvidia" ];` will now also install [nvidia VA-API drivers](https://github.com/elFarto/nvidia-vaapi-driver) by default.

- The `firmwareLinuxNonfree` package has been renamed to `linux-firmware`.

- It is now possible to specify wordlists to include as handy to access environment variables using the `config.environment.wordlist` configuration options.

- The `services.mbpfan` module was converted to a [RFC 0042](https://github.com/NixOS/rfcs/blob/master/rfcs/0042-config-option.md) configuration.

- The default value for `programs.spacefm.settings.graphical_su` got unset. It previously pointed to `gksu` which has been removed.

- The [Dino](https://dino.im) XMPP client was updated to 0.3, adding support for audio and video calls.

- `services.mattermost.plugins` has been added to allow the declarative installation of Mattermost plugins.
  Plugins are automatically repackaged using autoPatchelf.

- [services.logrotate.enable](#opt-services.logrotate.enable) now defaults to true if any rotate path has
  been defined, and some paths have been added by default.
- The logrotate module also has been updated to freeform syntax: `services.logrotate.paths`
  and `services.logrotate.extraConfig` will work, but issue deprecation
  warnings and [services.logrotate.settings](#opt-services.logrotate.settings) should now be used instead.

- `security.pam.ussh` has been added, which allows authorizing PAM sessions based on SSH _certificates_ held within an SSH agent, using [pam-ussh](https://github.com/uber/pam-ussh).

- The `vscode-extensions.ionide.ionide-fsharp` package has been updated to 6.0.0 and now requires .NET 6.0.

- The `phpPackages.box` package has been updated from 2.7.5 to 3.16.0. See the [upgrade guide](https://github.com/box-project/box/blob/master/UPGRADE.md#from-27-to-30) for more details.

- The `zrepl` package has been updated from 0.4.0 to 0.5:

  - The RPC protocol version was bumped; all zrepl daemons in a setup must be updated and restarted before replication can resume.
  - A bug involving encrypt-on-receive has been fixed. Read the [zrepl documentation](https://zrepl.github.io/configuration/sendrecvoptions.html#job-recv-options-placeholder) and check the output of `zfs get -r encryption,zrepl:placeholder PATH_TO_ROOTFS` on the receiver.

- The `polybar` package has been updated from 3.5.7 to 3.6.2. See [the changelog](https://github.com/polybar/polybar/releases/tag/3.6.0) for more details.
  - Breaking changes include changes to escaping rules in configuration values, changes in behavior when encountering invalid tag names, and changes to inter-process-messaging (IPC).

- Renamed option `services.openssh.challengeResponseAuthentication` to `services.openssh.kbdInteractiveAuthentication`.
  Reason is that the old name has been deprecated upstream.
  Using the old option name will still work, but produce a warning.

- `services.autorandr` now allows for adding hooks and profiles declaratively.

- The `pomerium-cli` command has been moved out of the `pomerium` package into
  the `pomerium-cli` package, following upstream's repository split. If you are
  using the `pomerium-cli` command, you should now install the `pomerium-cli`
  package.

- The option `services.networking.networkmanager.enableFccUnlock`
  was added to support FCC unlock procedures. Since release 1.18.4, the ModemManager
  daemon no longer automatically performs the FCC unlock procedure by default. See
  [the docs](https://modemmanager.org/docs/modemmanager/fcc-unlock/) for more details.

- `programs.tmux` has a new option `plugins` that accepts a list of packages from the `tmuxPlugins` group. The specified packages are added to the system and loaded by `tmux`.

- The polkit service, available at `security.polkit.enable`, is now disabled by default. It will automatically be enabled through services and desktop environments as needed.

- `mercury` was updated to 22.01.1, which has some breaking changes ([Mercury 22.01 news](https://dl.mercurylang.org/release/release-notes-22.01.html)).

- xfsprogs was update to version 5.15, which enables inobtcount and bigtime by default on filesystem creation. Support for these features was added in kernel 5.10 and deemed stable in kernel 5.15.
  If you want to be able to mount XFS filesystems created with this release of xfsprogs on kernel releases older than 5.10, you need to format them with `mkfs.xfs -m bigtime=0 -m inobtcount=0`.

- `services.xserver.desktopManager.xfce` now includes Xfce's screen locker, `xfce4-screensaver` that is enabled by default. You can disable it by setting `false` to [services.xserver.desktopManager.xfce.enableScreensaver](#opt-services.xserver.desktopManager.xfce.enableScreensaver).

- The `hadoop` package has added support for `aarch64-linux` and `aarch64-darwin` as of 3.3.1 ([#158613](https://github.com/NixOS/nixpkgs/pull/158613)).

- The `R` package now builds again on `aarch64-darwin` ([#158992](https://github.com/NixOS/nixpkgs/pull/158992)).

- The `nss` package was split into `nss_esr` and `nss_latest`, with `nss` being an alias for `nss_esr`. This was done to ease maintenance of `nss` and dependent high-profile packages like `firefox`.

- The default `scribus` version is now 1.5, while version 1.4 is still available as `scribus_1_4` ([#172700](https://github.com/NixOS/nixpkgs/pull/172700)).

- The Nextcloud module now supports to create a Mysql database automatically
  with `services.nextcloud.database.createLocally` enabled.

- The Nextcloud module now allows setting the value of the `max-age` directive of the `Strict-Transport-Security` HTTP header, which is now controlled by the `services.nextcloud.https` option, rather than `services.nginx.recommendedHttpHeaders`.

- The `spark3` package has been updated from 3.1.2 to 3.2.1 ([#160075](https://github.com/NixOS/nixpkgs/pull/160075)):

  - Testing has been enabled for `aarch64-linux` in addition to `x86_64-linux`.
  - The `spark3` package is now usable on `aarch64-darwin` as a result of [#158613](https://github.com/NixOS/nixpkgs/pull/158613) and [#158992](https://github.com/NixOS/nixpkgs/pull/158992).

- The option `services.snapserver.openFirewall` will no longer default to
  `true` starting with NixOS 22.11. Enable it explicitly if you need to control
  Snapserver remotely or connect streamig clients from other hosts.

- The option [networking.useDHCP](options.html#opt-networking.useDHCP) isn't deprecated anymore.
  When using [`systemd-networkd`](options.html#opt-networking.useNetworkd), a generic
  `.network`-unit is added which enables DHCP for each interface matching `en*`, `eth*`
  or `wl*` with priority 99 (which means that it doesn't have any effect if such an interface is matched
  by a `.network-`unit with a lower priority). In case of scripted networking, no behavior
  was changed.

- The new [`postgresqlTestHook`](https://nixos.org/manual/nixpkgs/stable/#sec-postgresqlTestHook) runs a PostgreSQL server for the duration of package checks.

- `zfs` was updated from 2.1.4 to 2.1.5, enabling it to be used with Linux kernel 5.18.

- `stdenv.mkDerivation` now supports a self-referencing `finalAttrs:` parameter
  containing the final `mkDerivation` arguments including overrides.
  `drv.overrideAttrs` now supports two parameters `finalAttrs: previousAttrs:`.
  This allows packaging configuration to be overridden in a consistent manner by
  providing an alternative to `rec {}` syntax.

  Additionally, `passthru` can now reference `finalAttrs.finalPackage` containing
  the final package, including attributes such as the output paths and
  `overrideAttrs`.

  New language integrations can be simplified by overriding a "prototype"
  package containing the language-specific logic. This removes the need for a
  extra layer of overriding for the "generic builder" arguments, thus removing a
  usability problem and source of error.

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->
