# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit autotools

DESCRIPTION="Music Player For Console"
HOMEPAGE="https://mpfc.sourceforge.net/"
SRC_URI="https://downloads.sourceforge.net/${PN}/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="amd64 ppc x86"
IUSE="alsa cdda flac gpm mad nls oss static-libs vorbis wav"

RDEPEND="alsa? ( >=media-libs/alsa-lib-0.9.0 )
	flac? ( media-libs/flac:= )
	gpm? ( >=sys-libs/gpm-1.19.3 )
	mad? ( media-libs/libmad )
	vorbis? ( media-libs/libvorbis )
	sys-libs/ncurses:=[unicode(+)]
	dev-libs/icu:="
DEPEND="${RDEPEND}"

PATCHES=(
	"${FILESDIR}/${P}-fix-underlinking.patch"
	"${FILESDIR}/${P}-qa-implicit-declarations.patch"
	"${FILESDIR}/${P}-c99-incompatible-pointers.patch"
)

src_prepare() {
	default
	eautoreconf
}

src_configure() {
	local myeconfargs=(
		$(use_enable alsa)
		$(use_enable cdda audiocd)
		$(use_enable flac)
		$(use_enable gpm)
		$(use_enable mad mp3)
		$(use_enable nls)
		$(use_enable oss)
		$(use_enable static-libs static)
		$(use_enable vorbis ogg)
		$(use_enable wav)
	)
	econf "${myeconfargs[@]}"
}

src_install() {
	default

	insinto /etc
	doins mpfcrc

	# package provides .pc files
	find "${D}" -name '*.la' -delete || die
}
