{
  lib,
  buildHomeAssistantComponent,
  fetchFromGitHub,
  charset-normalizer,
  pycountry,
  xmltodict,
}:

buildHomeAssistantComponent rec {
  owner = "ollo69";
  domain = "smartthinq_sensors";
  version = "0.41.2";

  src = fetchFromGitHub {
    inherit owner;
    repo = "ha-smartthinq-sensors";
    rev = "v${version}";
    hash = "sha256-HNhW72aoYu0Vosq8o0lyxDse8jcs3kVWEzDw/5VQn9g=";
  };

  dependencies = [
    charset-normalizer
    pycountry
    xmltodict
  ];

  meta = {
    description = "Home Assistant custom integration for SmartThinQ LG devices configurable with Lovelace User Interface";
    homepage = "https://github.com/ollo69/ha-smartthinq-sensors";
    changelog = "https://github.com/ollo69/ha-smartthinq-sensors/releases/tag/v${version}";
    maintainers = with lib.maintainers; [ k900 ];
    license = lib.licenses.asl20;
  };
}
