{
  lib,
  buildPythonPackage,
  fetchFromGitHub,
  setuptools,
  requests,
  pytestCheckHook,
  requests-mock,
}:

buildPythonPackage rec {
  pname = "remotezip";
  version = "0.12.3";
  pyproject = true;

  src = fetchFromGitHub {
    owner = "gtsystem";
    repo = "python-remotezip";
    tag = "v${version}";
    hash = "sha256-TNEM7Dm4iH4Z/P/PAqjJppbn1CKmyi9Xpq/sU9O8uxg=";
  };

  nativeBuildInputs = [ setuptools ];

  propagatedBuildInputs = [ requests ];

  nativeCheckInputs = [
    pytestCheckHook
    requests-mock
  ];

  pythonImportsCheck = [ "remotezip" ];

  meta = {
    description = "Python module to access single members of a zip archive without downloading the full content";
    mainProgram = "remotezip";
    homepage = "https://github.com/gtsystem/python-remotezip";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [ nickcao ];
  };
}
