{
  lib,
  buildPythonPackage,
  fetchPypi,
  gitpython,
  requests,
  setuptools,
}:

buildPythonPackage rec {
  pname = "pyexploitdb";
  version = "0.3.5";
  pyproject = true;

  src = fetchPypi {
    inherit pname version;
    hash = "sha256-YRiC4k1kJqswUsNAVcSFq5S5gPZZygT7DZO1r4X0fBY=";
  };

  build-system = [ setuptools ];

  dependencies = [
    gitpython
    requests
  ];

  # Module has no tests
  doCheck = false;

  pythonImportsCheck = [ "pyexploitdb" ];

  meta = {
    description = "Library to fetch the most recent exploit-database";
    homepage = "https://github.com/Hackman238/pyExploitDb";
    changelog = "https://github.com/Hackman238/pyExploitDb/blob/master/ChangeLog.md";
    license = lib.licenses.gpl3Plus;
    maintainers = with lib.maintainers; [ fab ];
  };
}
