{
  lib,
  buildPythonPackage,
  fetchFromGitHub,
  setuptools,
}:

#This python library is auto-generated. It should be possible to rebuild it from upstream, but seems unnecessary
buildPythonPackage rec {
  pname = "pmdsky-debug-py";
  version = "10.0.48";
  pyproject = true;
  # SkyTemple specifically require this version. This is used when patching the binary,
  # and risk to be a bit problematic if using the latest version, given it doesn’t follow semver.

  src = fetchFromGitHub {
    owner = "SkyTemple";
    repo = "pmdsky-debug-py";
    rev = version;
    sha256 = "sha256-JTvLyYUwOEp1O0rtO313VIT6AYOqXWVFUleTrb6BN6Q=";
  };

  prePatch = "cd src";

  nativeBuildInputs = [ setuptools ];

  meta = {
    description = "Autogenerated and statically check-able pmdsky-debug symbol definitions for Python";
    homepage = "https://github.com/SkyTemple/pmdsky-debug-py";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [ marius851000 ];
  };
}
