{
  lib,
  buildPythonPackage,
  fetchPypi,
  pdm-backend,
  tqdm,
  hypothesis,
  pytest,
}:

buildPythonPackage rec {
  pname = "partial-json-parser";
  version = "0.2.1.1.post7";
  pyproject = true;

  src = fetchPypi {
    pname = "partial_json_parser";
    inherit version;
    hash = "sha256-hlkOG6a8tnOaLfwX0jI/Aoy1iE9MbOI9s3aZkTLJqSI=";
  };

  build-system = [ pdm-backend ];

  dependencies = [ ];

  doCheck = true;

  pythonImportsCheck = [ "partial_json_parser" ];

  dev-dependencies = [
    hypothesis
    tqdm
    pytest
  ];

  meta = {
    description = "Parse partial JSON generated by LLM";
    homepage = "https://github.com/promplate/partial-json-parser";
    license = lib.licenses.mit;
    maintainers = [ ];
  };
}
