{
  lib,
  buildPythonPackage,
  fetchFromGitHub,
  protobuf,
  pycryptodome,
  pythonOlder,
  requests,
}:

buildPythonPackage rec {
  pname = "lakeside";
  version = "0.13";
  format = "setuptools";

  disabled = pythonOlder "3.7";

  src = fetchFromGitHub {
    owner = "nkgilley";
    repo = "python-lakeside";
    tag = version;
    hash = "sha256-Y5g78trkwOF3jsbgTv0uVkvfB1HZN+w1T6xIorxGAhg=";
  };

  propagatedBuildInputs = [
    protobuf
    pycryptodome
    requests
  ];

  # Module has no tests
  doCheck = false;

  pythonImportsCheck = [ "lakeside" ];

  meta = {
    description = "Library for controlling LED bulbs from Eufy";
    homepage = "https://github.com/nkgilley/python-lakeside";
    changelog = "https://github.com/nkgilley/python-lakeside/releases/tag/${version}";
    license = lib.licenses.asl20;
    maintainers = with lib.maintainers; [ fab ];
  };
}
