{
  lib,
  buildPythonPackage,
  fetchPypi,

  # build-system
  pdm-backend,

  # dependencies
  django-gravatar2,
  django-allauth,
  mailmanclient,
  pytz,

  # tests
  django,
  pytest-django,
  pytestCheckHook,
  nixosTests,
}:

buildPythonPackage rec {
  pname = "django-mailman3";
  version = "1.3.15";
  pyproject = true;

  src = fetchPypi {
    pname = "django_mailman3";
    inherit version;
    hash = "sha256-+ZFrJpy5xdW6Yde/XEvxoAN8+TSQdiI0PfjZ7bHG0Rs=";
  };

  pythonRelaxDeps = [ "django-allauth" ];

  build-system = [ pdm-backend ];

  dependencies = [
    django-allauth
    django-gravatar2
    mailmanclient
    pytz
  ]
  ++ django-allauth.optional-dependencies.openid
  ++ django-allauth.optional-dependencies.socialaccount;

  nativeCheckInputs = [
    django
    pytest-django
    pytestCheckHook
  ];

  preCheck = ''
    export DJANGO_SETTINGS_MODULE=django_mailman3.tests.settings_test
  '';

  pythonImportsCheck = [ "django_mailman3" ];

  passthru.tests = {
    inherit (nixosTests) mailman;
  };

  meta = {
    description = "Django library for Mailman UIs";
    homepage = "https://gitlab.com/mailman/django-mailman3";
    license = lib.licenses.gpl3Plus;
    maintainers = with lib.maintainers; [ qyliss ];
    broken = lib.versionAtLeast django-allauth.version "65.0.0";
  };
}
