{
  lib,
  appdirs,
  apsw,
  buildPythonPackage,
  cvss,
  fetchFromGitHub,
  httpx,
  msgpack,
  orjson,
  packageurl-python,
  pydantic,
  pytestCheckHook,
  pytest-cov-stub,
  rich,
  semver,
  setuptools,
  tabulate,
  writableTmpDirAsHomeHook,
}:

buildPythonPackage rec {
  pname = "appthreat-vulnerability-db";
  version = "6.4.4";
  pyproject = true;

  src = fetchFromGitHub {
    owner = "AppThreat";
    repo = "vulnerability-db";
    tag = "v${version}";
    hash = "sha256-bzr3RlTtWTH/P6hgiXjWvR1IbVtVSqbtrZHQ91o/V/E=";
  };

  pythonRelaxDeps = [
    "msgpack"
    "semver"
  ];

  build-system = [ setuptools ];

  dependencies = [
    appdirs
    apsw
    cvss
    httpx
    msgpack
    orjson
    packageurl-python
    pydantic
    rich
    semver
    tabulate
  ]
  ++ httpx.optional-dependencies.http2;

  nativeCheckInputs = [
    pytest-cov-stub
    pytestCheckHook
    writableTmpDirAsHomeHook
  ];

  preCheck = ''
    export HOME=$(mktemp -d);
  '';

  disabledTests = [
    # Tests require network access
    "test_bulk_search"
    "test_download_recent"
    "test_parse_purl"
  ];

  pythonImportsCheck = [ "vdb" ];

  meta = {
    description = "Vulnerability database and package search for sources such as OSV, NVD, GitHub and npm";
    homepage = "https://github.com/appthreat/vulnerability-db";
    changelog = "https://github.com/AppThreat/vulnerability-db/releases/tag/${src.tag}";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [ fab ];
    mainProgram = "vdb";
  };
}
