{
  lib,
  symlinkJoin,
  makeBinaryWrapper,
  nh-unwrapped,
  nix-output-monitor,
}:
let
  unwrapped = nh-unwrapped;
  runtimeDeps = [
    nix-output-monitor
  ];
in
symlinkJoin {
  pname = "nh";
  inherit (unwrapped) version;

  paths = [
    unwrapped
  ];

  nativeBuildInputs = [
    makeBinaryWrapper
  ];

  postBuild = ''
    wrapProgram $out/bin/nh \
      --prefix PATH : ${lib.makeBinPath runtimeDeps}
  '';

  meta = {
    inherit (unwrapped.meta)
      changelog
      description
      homepage
      license
      mainProgram
      maintainers
      ;

    # To prevent builds on hydra
    hydraPlatforms = [ ];
    # prefer wrapper over the package
    priority = (unwrapped.meta.priority or lib.meta.defaultPriority) - 1;
  };
}
