{
  lib,
  buildKodiAddon,
  fetchFromGitHub,
  inputstream-adaptive,
  inputstreamhelper,
  routing,
}:

buildKodiAddon rec {
  pname = "orftvthek";
  namespace = "plugin.video.orftvthek";
  version = "1.0.3+matrix.1";

  src = fetchFromGitHub {
    owner = "s0faking";
    repo = namespace;
    rev = version;
    sha256 = "sha256-HWx1Uj/yOJ5Tggyd8EJHyBfpUAbtfk89XpWTKzl6Ie0=";
  };

  propagatedBuildInputs = [
    # Needed for content decryption with Widevine.
    inputstream-adaptive
    inputstreamhelper
    routing
  ];

  meta = {
    homepage = "https://github.com/s0faking/plugin.video.orftvthek";
    description = "Addon for accessing the Austrian ORF ON streaming service";
    license = lib.licenses.gpl2Only;
    teams = [ lib.teams.kodi ];
  };
}
