{
  lib,
  buildPythonPackage,
  fetchPypi,
  gitpython,
  requests,
  setuptools,
}:

buildPythonPackage rec {
  pname = "pyexploitdb";
  version = "0.3.4";
  pyproject = true;

  src = fetchPypi {
    inherit pname version;
    hash = "sha256-62uayIMtvFWX0SYHT0jz18wsIiRp/R7D6DNhOsCbT3s=";
  };

  build-system = [ setuptools ];

  dependencies = [
    gitpython
    requests
  ];

  # Module has no tests
  doCheck = false;

  pythonImportsCheck = [ "pyexploitdb" ];

  meta = {
    description = "Library to fetch the most recent exploit-database";
    homepage = "https://github.com/Hackman238/pyExploitDb";
    changelog = "https://github.com/Hackman238/pyExploitDb/blob/master/ChangeLog.md";
    license = lib.licenses.gpl3Plus;
    maintainers = with lib.maintainers; [ fab ];
  };
}
