{
  lib,
  stdenv,
  fetchurl,
  dpkg,
  autoPatchelfHook,
}:

stdenv.mkDerivation rec {
  pname = "sslmate-agent";
  version = "1.99.11";

  src = fetchurl {
    url = "https://packages.sslmate.com/debian/pool/sslmate2/s/sslmate-client/${pname}_${version}-1_amd64.deb";
    sha256 = "sha256-LBiZI0pGAFWnvTigEhtkhHq4FGdbYiMzjLheMuP0YTU=";
  };

  nativeBuildInputs = [
    dpkg
    autoPatchelfHook
  ];

  installPhase = ''
    runHook preInstall

    # Not moving etc because it only contains init.rd setttings
    mv usr $out
    mv lib $out

    substituteInPlace $out/lib/systemd/system/sslmate-agent.service \
      --replace "/usr/s" "$out/"

    runHook postInstall
  '';

  meta = {
    description = "Daemon for managing SSL/TLS certificates on a server";
    homepage = "https://sslmate.com/";
    sourceProvenance = with lib.sourceTypes; [ binaryNativeCode ];
    license = lib.licenses.unfree;
    maintainers = [ ];
  };
}
