{
  lib,
  stdenvNoCC,
  fetchzip,
}:

stdenvNoCC.mkDerivation rec {
  pname = "quattrocento";
  version = "1.1";

  src = fetchzip {
    url = "https://web.archive.org/web/20170707001804/http://www.impallari.com/media/releases/quattrocento-v${version}.zip";
    hash = "sha256-ntY6Wl6TI8F7SShMyD8mdOxVg4oz9kvJ7vKTyGdPLtE=";
  };

  installPhase = ''
    runHook preInstall

    install -Dm644 */*.otf     -t $out/share/fonts/opentype
    install -Dm644 FONTLOG.txt -t $out/share/doc/${pname}-${version}

    runHook postInstall
  '';

  meta = {
    homepage = "http://www.impallari.com/quattrocento/";
    description = "Classic, elegant, sober and strong serif typeface";
    license = lib.licenses.ofl;
    platforms = lib.platforms.all;
    maintainers = [ lib.maintainers.rycee ];
  };
}
