{
  lib,
  python3,
  fetchFromGitHub,
}:

python3.pkgs.buildPythonApplication rec {
  pname = "proxmove";
  version = "1.2";
  pyproject = true;

  src = fetchFromGitHub {
    owner = "ossobv";
    repo = "proxmove";
    rev = "v${version}";
    hash = "sha256-8xzsmQsogoMrdpf8+mVZRWPGQt9BO0dBT0aKt7ygUe4=";
  };

  build-system = with python3.pkgs; [
    setuptools
  ];

  dependencies = with python3.pkgs; [
    proxmoxer
  ];

  preBuild = ''
    rm -R assets
    rm -R artwork
  '';

  checkPhase = ''
    runHook preCheck

    $out/bin/${pname} --version

    runHook postCheck
  '';

  meta = {
    description = "Proxmox VM migrator: migrates VMs between different Proxmox VE clusters";
    mainProgram = "proxmove";
    homepage = "https://github.com/ossobv/proxmove";
    license = lib.licenses.gpl3Plus;
    platforms = lib.platforms.linux;
    maintainers = with lib.maintainers; [ AngryAnt ];
  };
}
