{
  autoreconfHook,
  fetchurl,
  lib,
  stdenv,
  ...
}:
stdenv.mkDerivation (finalAttrs: {
  pname = "partclone-utils";
  version = "0.4.3";

  src = fetchurl {
    url = "mirror://sourceforge/partclone-utils/${finalAttrs.pname}-${finalAttrs.version}.tar.gz";
    sha256 = "sha256-HcmLT48mz9FmdO31Ti4uOT78tLEml4ezYWyp5fltkDA=";
  };

  nativeBuildInputs = [ autoreconfHook ];

  meta = {
    description = "library and utility to access and mount images generated by partclone, ntfsclone and raw (dd) images";
    homepage = "https://partclone-utils.sourceforge.io/";
    license = lib.licenses.gpl2;
    mainProgram = "imagemount";
    maintainers = [ lib.maintainers.johnrichardrinehart ];
  };
})
