{
  lib,
  stdenv,
  fetchurl,
}:

stdenv.mkDerivation (finalAttrs: {
  pname = "nrg2iso";
  version = "0.4.1";

  src = fetchurl {
    url = "http://gregory.kokanosky.free.fr/v4/linux/nrg2iso-${finalAttrs.version}.tar.gz";
    hash = "sha256-O+NqQWdY/BkQRztJqNrfKiqj1R8ZdhlzNrwXS8HjBuU=";
  };

  patches = [ ./c-compiler.patch ];

  installPhase = ''
    mkdir -pv $out/bin/
    cp -v nrg2iso $out/bin/nrg2iso
  '';

  meta = {
    description = "Linux utils for converting CD (or DVD) image generated by Nero Burning Rom to ISO format";
    homepage = "http://gregory.kokanosky.free.fr/v4/linux/nrg2iso.en.html";
    license = lib.licenses.gpl2Plus;
    platforms = lib.platforms.all;
    mainProgram = "nrg2iso";
  };
})
