{
  buildNpmPackage,
  cctools,
  fetchFromGitHub,
  lib,
  node-gyp,
  nodejs,
  python3,
  stdenv,
}:

buildNpmPackage {
  pname = "nodehun";
  version = "3.0.2";

  src = fetchFromGitHub {
    owner = "Wulf";
    repo = "nodehun";
    rev = "03c9dcf1fcd965031a68553ccaf6487d1fe87f79";
    hash = "sha256-MoY95lSIQK1K4aIlMdPm93YxJuez9HYx2zlUhHvDao0=";
  };

  patches = [
    # Remove the dependency on "nodemon", which is only needed for interactive
    # development. This package depends on fsevents on macOS, which has
    # repeatedly caused build problems. This patch is generated by checking out
    # the upstream source and removing the "nodemon" line, and then running
    #
    # npm install --lockfile-version 1
    ./remove-nodemon.patch
  ];

  npmDepsHash = "sha256-GyNUPgLJhdjzbIpld916/l8durIw0aQRHojjSmGgEJE=";
  nativeBuildInputs = [
    node-gyp
    python3
  ]
  ++ lib.optionals stdenv.hostPlatform.isDarwin [ cctools ];

  postInstall = ''
    # Only keep the necessary parts of build/Release to reduce closure size
    cd $out/lib/node_modules/nodehun
    mv build build_old
    mkdir build
    cp -r build_old/Release build/
    rm -rf build_old
    rm -rf build/Release/.deps

    # Remove a development script to eliminate runtime dependency on node
    rm node_modules/node-addon-api/tools/conversion.js

    # Remove dangling symlinks
    rm -rf $out/lib/node_modules/nodehun/node_modules/.bin
  '';

  doInstallCheck = true;
  nativeCheckInputs = [ nodejs ];
  postInstallCheck = ''
    # Smoke check: require() works
    export NODE_PATH=$out/lib/node_modules
    echo 'require("nodehun")' | node -
  '';

  disallowedReferences = [ nodejs ];

  meta = {
    description = "Hunspell binding for NodeJS that exposes as much of Hunspell as possible and also adds new features";
    homepage = "https://github.com/Wulf/nodehun";
    license = lib.licenses.mit;
    maintainers = [ lib.maintainers.thomasjm ];
  };
}
