{
  lib,
  stdenv,
  ruby,
  rake,
  fetchFromGitHub,
  fetchpatch,
  testers,
}:

stdenv.mkDerivation (finalAttrs: {
  pname = "mruby";
  version = "3.3.0";

  src = fetchFromGitHub {
    owner = "mruby";
    repo = "mruby";
    rev = finalAttrs.version;
    sha256 = "sha256-rCoEC1ioX6bOocPoPi+Lsn4PM8gY0DjKja1/MJvJ1n8=";
  };

  patches = [
    (fetchpatch {
      name = "CVE-2025-7207.patch";
      url = "https://github.com/mruby/mruby/commit/1fdd96104180cc0fb5d3cb086b05ab6458911bb9.patch";
      hash = "sha256-wtSlLydofkp2brk/pRiJqt4NhkGRdzsx7JpTmWu2B7I=";
    })
  ];

  nativeBuildInputs = [ rake ];

  nativeCheckInputs = [ ruby ];

  # Necessary so it uses `gcc` instead of `ld` for linking.
  # https://github.com/mruby/mruby/blob/e502fd88b988b0a8d9f31b928eb322eae269c45a/tasks/toolchains/gcc.rake#L30
  preBuild = "unset LD";

  installPhase = ''
    mkdir $out
    cp -R include build/host/{bin,lib} $out
  '';

  doCheck = true;

  checkTarget = "test";

  passthru.tests = {
    version = testers.testVersion {
      package = finalAttrs.finalPackage;
    };
  };

  meta = {
    description = "Embeddable implementation of the Ruby language";
    homepage = "https://mruby.org";
    maintainers = with lib.maintainers; [ nicknovitski ];
    license = lib.licenses.mit;
    platforms = lib.platforms.all;
    mainProgram = "mruby";
  };
})
