{
  python3Packages,
  fetchFromGitHub,
  lib,
}:

python3Packages.buildPythonApplication rec {
  pname = "mnamer";
  version = "2.5.5";
  format = "pyproject";

  src = fetchFromGitHub {
    owner = "jkwill87";
    repo = "mnamer";
    tag = version;
    sha256 = "sha256-qQu5V1GOsbrR00HOrot6TTAkc3KRasBPDEU7ZojUBio=";
  };

  build-system = with python3Packages; [
    setuptools
    setuptools-scm
  ];

  dependencies = with python3Packages; [
    appdirs
    babelfish
    guessit
    requests
    requests-cache
    teletype
  ];

  pythonRelaxDeps = true;

  patches = [
    # https://github.com/jkwill87/mnamer/pull/291
    ./cached_session_error.patch
  ];

  nativeCheckInputs = [ python3Packages.pytestCheckHook ];

  # disable test that fail (networking, etc)
  disabledTests = [
    "network"
    "e2e"
    "test_utils.py"
  ];

  meta = {
    homepage = "https://github.com/jkwill87/mnamer";
    description = "Intelligent and highly configurable media organization utility";
    mainProgram = "mnamer";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [ urlordjames ];
  };
}
