# generated by zon2nix (https://github.com/Cloudef/zig2nix)

{
  lib,
  linkFarm,
  fetchurl,
  fetchgit,
  runCommandLocal,
  zig,
  name ? "zig-packages",
}:

with builtins;
with lib;

let
  unpackZigArtifact =
    { name, artifact }:
    runCommandLocal name { nativeBuildInputs = [ zig ]; } ''
      hash="$(zig fetch --global-cache-dir "$TMPDIR" ${artifact})"
      mv "$TMPDIR/p/$hash" "$out"
      chmod 755 "$out"
    '';

  fetchZig =
    {
      name,
      url,
      hash,
    }:
    let
      artifact = fetchurl { inherit url hash; };
    in
    unpackZigArtifact { inherit name artifact; };

  fetchGitZig =
    {
      name,
      url,
      hash,
      rev ? throw "rev is required, remove and regenerate the zon2json-lock file",
    }:
    let
      parts = splitString "#" url;
      url_base = elemAt parts 0;
      url_without_query = elemAt (splitString "?" url_base) 0;
    in
    fetchgit {
      inherit name rev hash;
      url = url_without_query;
      deepClone = false;
    };

  fetchZigArtifact =
    {
      name,
      url,
      hash,
      ...
    }@args:
    let
      parts = splitString "://" url;
      proto = elemAt parts 0;
      path = elemAt parts 1;
      fetcher = {
        "git+http" = fetchGitZig (
          args
          // {
            url = "http://${path}";
          }
        );
        "git+https" = fetchGitZig (
          args
          // {
            url = "https://${path}";
          }
        );
        http = fetchZig {
          inherit name hash;
          url = "http://${path}";
        };
        https = fetchZig {
          inherit name hash;
          url = "https://${path}";
        };
      };
    in
    fetcher.${proto};
in
linkFarm name [
  {
    name = "clap-0.11.0-oBajB-HnAQDPCKYzwF7rO3qDFwRcD39Q0DALlTSz5H7e";
    path = fetchZigArtifact {
      name = "clap";
      url = "https://github.com/Hejsil/zig-clap/archive/refs/tags/0.11.0.tar.gz";
      hash = "sha256-fDWd7EQYZuAlBlrpynBuznK89OiiX74xcZsekv84lkg=";
    };
  }
  {
    name = "zigini-0.3.3-36M0FRJJAADZVq5HPm-hYKMpFFTr0OgjbEYcK2ijKZ5n";
    path = fetchZigArtifact {
      name = "zigini";
      url = "https://github.com/AnErrupTion/zigini/archive/9281f47702b57779e831d7618e158abb8eb4d4a2.tar.gz";
      hash = "sha256-/g0az0MRQOmww0DhZQo/1YH2qkJcscoCpaoW4pWGVIk=";
    };
  }
  {
    name = "ini-0.1.0-YCQ9Ys0pAABixEvvQvhVXAdqRE3wrZk_wiL9TPNHhB8d";
    path = fetchZigArtifact {
      name = "ini";
      url = "https://github.com/AnErrupTion/ini/archive/918f16d0dcf893d0c1cdffe204faa08bb3584e04.tar.gz";
      hash = "sha256-z2IMS0grfnf33h6tz1ERv2i6gfnS6p8oMWFz+AmGoA8=";
    };
  }
  {
    name = "N-V-__8AAGcUBQAa5vov1Yi_9AXEffFQ1e2KsXaK4dgygRKq";
    path = fetchZigArtifact {
      name = "termbox2";
      url = "git+https://github.com/AnErrupTion/termbox2?ref=master#290ac6b8225aacfd16851224682b851b65fcb918";
      hash = "sha256-of95/wJeCTWI3p7NxvnUlb618qffUZv2YxgBgzp+crs=";
      rev = "290ac6b8225aacfd16851224682b851b65fcb918";
    };
  }
]
