{
  stdenv,
  lib,
  fetchurl,
  meson,
  ninja,
  pkg-config,
  gtk-doc,
  docbook-xsl-nons,
  glib,
  ncurses,
  libxml2,
  buildDocs ? true,
  mesonEmulatorHook,
}:
stdenv.mkDerivation rec {
  pname = "libgnt";
  version = "2.14.4-dev";

  outputs = [
    "out"
    "dev"
  ]
  ++ lib.optional buildDocs "devdoc";

  src = fetchurl {
    url = "mirror://sourceforge/pidgin/${pname}-${version}.tar.xz";
    hash = "sha256-GVkzqacx01dXkbiBulzArSpxXh6cTCPMqqKhfhZMluw=";
  };

  nativeBuildInputs = [
    glib
    meson
    ninja
    pkg-config
  ]
  ++ lib.optionals buildDocs [
    gtk-doc
    docbook-xsl-nons
  ]
  ++ lib.optionals (buildDocs && !stdenv.buildPlatform.canExecute stdenv.hostPlatform) [
    mesonEmulatorHook
  ];

  buildInputs = [
    glib
    ncurses
    libxml2
  ];

  postPatch = ''
    substituteInPlace meson.build --replace-fail \
      "ncurses_sys_prefix = '/usr'" \
      "ncurses_sys_prefix = '${lib.getDev ncurses}'"
  '';
  mesonFlags = [
    (lib.mesonBool "doc" buildDocs)
    (lib.mesonBool "python2" false)
  ];

  meta = {
    description = "Ncurses toolkit for creating text-mode graphical user interfaces";
    homepage = "https://keep.imfreedom.org/libgnt/libgnt/";
    license = lib.licenses.gpl2Plus;
    platforms = lib.platforms.unix;
    maintainers = with lib.maintainers; [ ony ];
  };
}
