{
  lib,
  stdenv,
  fetchFromGitHub,
  cmake,
  curl,
  pkg-config,
  staticOnly ? stdenv.hostPlatform.isStatic,
}:

let
  version = "1.14.1";
in
stdenv.mkDerivation {
  pname = "libcpr";
  inherit version;

  outputs = [
    "out"
    "dev"
  ];

  src = fetchFromGitHub {
    owner = "libcpr";
    repo = "cpr";
    rev = version;
    hash = "sha256-kwbkdAeTpkEJbzvqpUQx007ZIBtwqOPG8n41TvFxeiM=";
  };

  nativeBuildInputs = [
    cmake
    pkg-config
  ];

  propagatedBuildInputs = [ curl ];

  cmakeFlags = [
    (lib.cmakeBool "BUILD_SHARED_LIBS" (!staticOnly))
    (lib.cmakeBool "CPR_USE_SYSTEM_CURL" true)
  ];

  postPatch = ''
    # Linking with stdc++fs is no longer necessary.
    sed -i '/stdc++fs/d' include/CMakeLists.txt
  '';

  postInstall = ''
    substituteInPlace "$out/lib/cmake/cpr/cprTargets.cmake" \
      --replace-fail "_IMPORT_PREFIX \"$out\"" \
                     "_IMPORT_PREFIX \"$dev\""
  '';

  meta = {
    description = "C++ wrapper around libcurl";
    homepage = "https://docs.libcpr.org/";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [
      phodina
      rycee
    ];
    platforms = lib.platforms.all;
  };
}
