{
  stdenv,
  lib,
  fetchFromGitHub,
  ant,
  jdk,
  stripJavaArchivesHook,
}:

stdenv.mkDerivation (finalAttrs: {
  pname = "jna";
  version = "5.18.1";

  src = fetchFromGitHub {
    owner = "java-native-access";
    repo = "jna";
    rev = finalAttrs.version;
    hash = "sha256-S0magEmA/Gw/26ZdjVnRTOJxBmRiw8DLQg49pRmaUU4=";
  };

  nativeBuildInputs = [
    ant
    jdk
    stripJavaArchivesHook
  ];

  buildPhase = ''
    runHook preBuild
    rm -r dist # remove prebuilt files
    ant dist
    runHook postBuild
  '';

  installPhase = ''
    runHook preInstall
    install -Dm444 -t $out/share/java dist/jna{,-platform}.jar
    runHook postInstall
  '';

  meta = {
    changelog = "https://github.com/java-native-access/jna/blob/${finalAttrs.version}/CHANGES.md";
    description = "Java Native Access";
    homepage = "https://github.com/java-native-access/jna";
    license = with lib.licenses; [
      lgpl21
      asl20
    ];
    maintainers = with lib.maintainers; [ nagy ];
    platforms = lib.platforms.linux ++ lib.platforms.darwin;
  };
})
