{
  lib,
  buildGoModule,
  fetchFromGitHub,
}:

buildGoModule rec {
  pname = "go-exploitdb";
  version = "0.6.3";

  src = fetchFromGitHub {
    owner = "vulsio";
    repo = "go-exploitdb";
    tag = "v${version}";
    hash = "sha256-GT5kEEYdjyHQTF0m9pMX+uxH++BuA8ORIL7loc5hSfI=";
  };

  vendorHash = "sha256-8xUoCamF2VV+D04XBwc3OtQTI2/j6uMbhmDXpHQZxXI=";

  ldflags = [
    "-s"
    "-w"
    "-X=github.com/vulsio/go-exploitdb/config.Version=${version}"
  ];

  meta = {
    description = "Tool for searching Exploits from Exploit Databases, etc";
    mainProgram = "go-exploitdb";
    homepage = "https://github.com/vulsio/go-exploitdb";
    changelog = "https://github.com/vulsio/go-exploitdb/releases/tag/v${version}";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [ fab ];
  };
}
