{
  lib,
  stdenv,
  fetchurl,
  jre_headless,
  makeWrapper,
  testers,
}:

stdenv.mkDerivation (finalAttrs: {
  pname = "flyway";
  version = "11.14.1";
  src = fetchurl {
    url = "https://github.com/flyway/flyway/releases/download/flyway-${finalAttrs.version}/flyway-commandline-${finalAttrs.version}.tar.gz";
    sha256 = "sha256-NWxt7qOiANk847cHbs916jNaZlUZynRlrVP321MkqOs=";
  };
  nativeBuildInputs = [ makeWrapper ];
  dontBuild = true;
  dontStrip = true;
  installPhase = ''
    mkdir -p $out/bin $out/share/flyway
    cp -r drivers conf licenses README.txt $out/share/flyway
    find lib -type f -name "*.jar" | while read -r file; do
        dest="$out/share/flyway/lib/''${file#lib/}"
        install -D "$file" "$dest"
    done
    makeWrapper "${jre_headless}/bin/java" $out/bin/flyway \
      --add-flags "-Djava.security.egd=file:/dev/../dev/urandom" \
      --add-flags "-classpath '$out/share/flyway/lib/*:$out/share/flyway/lib/flyway/*:$out/share/flyway/lib/aad/*:$out/share/flyway/lib/netty/*:$out/share/flyway/drivers/*'" \
      --add-flags "org.flywaydb.commandline.Main" \
  '';
  passthru.tests = {
    version = testers.testVersion { package = finalAttrs.finalPackage; };
  };
  meta = {
    description = "Evolve your Database Schema easily and reliably across all your instances";
    longDescription = ''
      The Flyway command-line tool is a standalone Flyway distribution.
      It is primarily meant for users who wish to migrate their database from the command-line
      without having to integrate Flyway into their applications nor having to install a build tool.

      This package is only the Community Edition of the Flyway command-line tool.
    '';
    mainProgram = "flyway";
    downloadPage = "https://github.com/flyway/flyway";
    homepage = "https://flywaydb.org/";
    changelog = "https://documentation.red-gate.com/fd/release-notes-for-flyway-engine-179732572.html";
    sourceProvenance = with lib.sourceTypes; [ binaryBytecode ];
    license = lib.licenses.asl20;
    platforms = lib.platforms.unix;
    maintainers = [ lib.maintainers.cmcdragonkai ];
  };
})
