{
  lib,
  stdenv,
  fetchFromGitHub,
  fetchpatch,
  pkg-config,
  cmake,
  libuuid,
}:

stdenv.mkDerivation rec {

  pname = "biblesync";
  version = "2.1.0";

  src = fetchFromGitHub {
    owner = "karlkleinpaste";
    repo = "biblesync";
    tag = version;
    sha256 = "0prmd12jq2cjdhsph5v89y38j7hhd51dr3r1hivgkhczr3m5hf4s";
  };

  patches = [
    # Fix cmake-4 support
    (fetchpatch {
      name = "cmake-4.patch";
      url = "https://github.com/karlkleinpaste/biblesync/commit/4b00f9fd3d0c858947eee18206ef44f9f6bd2283.patch?full_index=1";
      hash = "sha256-CVYhYBDneLN3Ogvye01EQCc9zxjSwaKBzk1fBaKINug=";
    })
  ];

  nativeBuildInputs = [
    pkg-config
    cmake
  ];
  buildInputs = [ libuuid ];

  meta = {
    homepage = "https://wiki.crosswire.org/BibleSync";
    description = "Multicast protocol to Bible software shared conavigation";
    longDescription = ''
      BibleSync is a multicast protocol to support Bible software shared
      co-navigation. It uses LAN multicast in either a personal/small team
      mutual navigation motif or in a classroom environment where there are
      Speakers plus the Audience. The library implementing the protocol is a
      single C++ class providing a complete yet minimal public interface to
      support mode setting, setup for packet reception, transmit on local
      navigation, and handling of incoming packets.
    '';
    license = lib.licenses.publicDomain;
    maintainers = [ ];
    platforms = lib.platforms.linux;
  };
}
