{
  lib,
  stdenv,
  alsa-utils,
  installShellFiles,
}:

stdenv.mkDerivation (finalAttrs: {
  pname = "alsa-utils-nhlt";
  inherit (alsa-utils) version src;

  outputs = [
    "out"
    "man"
  ];

  nativeBuildInputs = [ installShellFiles ];

  # The configure script insists on various headers and libraries from
  # alsa-lib and cannot be convinced to forego the respective checks. To
  # avoid dependency on alsa-lib we therefore circumvent the usual build
  # flow and compile the source directly.
  dontConfigure = true;

  postPatch = ''
    # The aconfig.h header is normally generated by the configure script and
    # even though included it is not actually used. Drop in an empty dummy
    # header.
    touch nhlt/aconfig.h
  '';

  buildPhase = ''
    runHook preBuild

    # Compile flags -g -O2 mirroring configure script.
    $CC -g -O2 -o nhlt-dmic-info nhlt/nhlt-dmic-info.c

    runHook postBuild
  '';

  installPhase = ''
    runHook preInstall

    installBin nhlt-dmic-info
    installManPage nhlt/nhlt-dmic-info.1

    runHook postInstall
  '';

  meta = {
    description = "Tool to extract microphone array information from ACPI NHLT table";
    homepage = "http://www.alsa-project.org/";
    license = lib.licenses.gpl2Plus;
    maintainers = with lib.maintainers; [ mvs ];
    mainProgram = "nhlt-dmic-info";
    platforms = lib.platforms.linux;
  };
})
