{
  buildPecl,
  lib,
  fetchFromGitHub,
}:

let
  version = "1.1.3";
in
buildPecl {
  inherit version;
  pname = "ast";

  src = fetchFromGitHub {
    owner = "nikic";
    repo = "php-ast";
    rev = "v${version}";
    sha256 = "sha256-TGMZA3Qe+/TwG+FIevrcQzy/ufCyN8sXKjsPrnz3K1Q=";
  };

  meta = with lib; {
    changelog = "https://github.com/nikic/php-ast/releases/tag/v${version}";
    description = "Exposes the abstract syntax tree generated by PHP";
    license = licenses.bsd3;
    homepage = "https://pecl.php.net/package/ast";
    teams = [ teams.php ];
  };
}
