# Release 14.04 ("Baboon", 2014/04/30) {#sec-release-14.04}

This is the second stable release branch of NixOS. In addition to numerous new and upgraded packages and modules, this release has the following highlights:

- Installation on UEFI systems is now supported. See [](#sec-installation) for details.

- Systemd has been updated to version 212, which has [numerous improvements](http://cgit.freedesktop.org/systemd/systemd/plain/NEWS?id=v212). NixOS now automatically starts systemd user instances when you log in. You can define global user units through the `systemd.unit.*` options.

- NixOS is now based on Glibc 2.19 and GCC 4.8.

- The default Linux kernel has been updated to 3.12.

- KDE has been updated to 4.12.

- GNOME 3.10 experimental support has been added.

- Nix has been updated to 1.7 ([details](https://nixos.org/nix/manual/#ssec-relnotes-1.7)).

- NixOS now supports fully declarative management of users and groups. If you set `users.mutableUsers` to `false`, then the contents of `/etc/passwd` and `/etc/group` will be [congruent](https://www.usenix.org/legacy/event/lisa02/tech/full_papers/traugott/traugott_html/) to your NixOS configuration. For instance, if you remove a user from `users.extraUsers` and run `nixos-rebuild`, the user account will cease to exist. Also, imperative commands for managing users and groups, such as `useradd`, are no longer available. If `users.mutableUsers` is `true` (the default), then behaviour is unchanged from NixOS 13.10.

- NixOS now has basic container support, meaning you can easily run a NixOS instance as a container in a NixOS host system. These containers are suitable for testing and experimentation but not production use, since they're not fully isolated from the host. See [](#ch-containers) for details.

- Systemd units provided by packages can now be overridden from the NixOS configuration. For instance, if a package `foo` provides systemd units, you can say:

  ```nix
  { systemd.packages = [ pkgs.foo ]; }
  ```

  to enable those units. You can then set or override unit options in the usual way, e.g.

  ```nix
  {
    systemd.services.foo.wantedBy = [ "multi-user.target" ];
    systemd.services.foo.serviceConfig.MemoryLimit = "512M";
  }
  ```

  When upgrading from a previous release, please be aware of the following incompatible changes:

- Nixpkgs no longer exposes unfree packages by default. If your NixOS configuration requires unfree packages from Nixpkgs, you need to enable support for them explicitly by setting:

  ```nix
  { nixpkgs.config.allowUnfree = true; }
  ```

  Otherwise, you get an error message such as:

  ```ShellSession
      error: package ‘nvidia-x11-331.49-3.12.17’ in ‘…/nvidia-x11/default.nix:56’
        has an unfree license, refusing to evaluate
  ```

- The Adobe Flash player is no longer enabled by default in the Firefox and Chromium wrappers. To enable it, you must set:

  ```nix
  {
    nixpkgs.config.allowUnfree = true;
    nixpkgs.config.firefox.enableAdobeFlash = true; # for Firefox
    nixpkgs.config.chromium.enableAdobeFlash = true; # for Chromium
  }
  ```

- The firewall is now enabled by default. If you don't want this, you need to disable it explicitly:

  ```nix
  { networking.firewall.enable = false; }
  ```

- The option `boot.loader.grub.memtest86` has been renamed to `boot.loader.grub.memtest86.enable`.

- The `mysql55` service has been merged into the `mysql` service, which no longer sets a default for the option `services.mysql.package`.

- Package variants are now differentiated by suffixing the name, rather than the version. For instance, `sqlite-3.8.4.3-interactive` is now called `sqlite-interactive-3.8.4.3`. This ensures that `nix-env -i sqlite` is unambiguous, and that `nix-env -u` won't "upgrade" `sqlite` to `sqlite-interactive` or vice versa. Notably, this change affects the Firefox wrapper (which provides plugins), as it is now called `firefox-wrapper`. So when using `nix-env`, you should do `nix-env -e firefox; nix-env -i firefox-wrapper` if you want to keep using the wrapper. This change does not affect declarative package management, since attribute names like `pkgs.firefoxWrapper` were already unambiguous.

- The symlink `/etc/ca-bundle.crt` is gone. Programs should instead use the environment variable `OPENSSL_X509_CERT_FILE` (which points to `/etc/ssl/certs/ca-bundle.crt`).
