#! /usr/bin/env nix-shell
#! nix-shell -i bash -p coreutils jq -I nixpkgs=.

set -euo pipefail

TMP_TEMPLATE=transitive-broken.XXXXXXX
readonly TMP_TEMPLATE

tmpfile=$(mktemp "$TMP_TEMPLATE")

trap 'rm -f "${tmpfile}"' 0

config_file=pkgs/development/haskell-modules/configuration-hackage2nix/transitive-broken.yaml

cat > $tmpfile << EOF
# This file is automatically generated by
# maintainers/scripts/haskell/regenerate-transitive-broken-packages.sh
# It is supposed to list all haskellPackages that cannot evaluate because they
# depend on a dependency marked as broken.
dont-distribute-packages:
EOF

nix-instantiate --eval --option restrict-eval true -I . --strict --json maintainers/scripts/haskell/transitive-broken-packages.nix | jq -r . | LC_ALL=C.UTF-8 sort --ignore-case >> $tmpfile

mv $tmpfile $config_file
