# Nixpkgs 25.11 ("Xantusia", 2025.11/??) {#sec-nixpkgs-release-25.11}

## Highlights {#sec-nixpkgs-release-25.11-highlights}
<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

- The initial work to support native compilation on LoongArch64 has completed, with further changes currently
  in preparation. In accordance with the [Software Development and Build Convention for LoongArch Architectures](https://github.com/loongson/la-softdev-convention),
  this release sets the default march level to `la64v1.0`, covering the desktop and server processors of 3X5000
  and newer series. However, embedded chips without LSX (Loongson SIMD eXtension), such as 2K0300 SoC, are not
  supported. `pkgsCross.loongarch64-linux-embedded` can be used to build software and systems for these platforms.
- The official Nix formatter `nixfmt` is now stable and available as `pkgs.nixfmt`, deprecating the temporary `pkgs.nixfmt-rfc-style` attribute. The classic `nixfmt` will stay available for some more time as `pkgs.nixfmt-classic`.
- The default GHC version has been updated from 9.8 to 9.10.
  `haskellPackages` correspondingly uses Stackage LTS 24 (instead of LTS 23) as a baseline.

- Darwin has switched to using the system libc++. This was done for improved compatibility and to avoid ODR violations.
  If a newer C++ library feature is not available on the default deployment target, you will need to increase the deployment target.
  See the Darwin platform documentation for more details.

- LLVM has been updated from 19 to 21.

## Backward Incompatibilities {#sec-nixpkgs-release-25.11-incompatibilities}

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

- `nixVersions.nix_2_3` has been dropped because it was insecure and unmaintained.

- The minimum version of Nix required to evaluate Nixpkgs has been raised from 2.3 to 2.18.

- `mono4` and `mono5` have been removed. Use `mono6` or `mono` instead.

- Everything related to `bower` was removed, as it is deprecated and not used by anything in nixpkgs.

- The `offrss` package was removed due to lack of upstream maintenance since 2012. It's recommended for users to migrate to another RSS reader

- `installShellFiles`: Allow installManPage to take a piped input, add the `--name` flag for renaming the file when installed. Can also append `--` to opt-out of all subsequent parsing.

- GCC 9, 10, 11, and 12 have been removed, as they have reached end‐of‐life upstream and are no longer supported.

- LLVM 12, 13, 14, 15, 16, and 17 have been removed, as they have reached end‐of‐life upstream and are no longer supported.

- GHCJS 8.10, exposed via `haskell.compiler.ghcjs` and `haskell.compiler.ghcjs810`, has been removed. Downstream users should migrate their projects to the new JavaScript backend of GHC proper which can be used via `pkgsCross.ghcjs` from Nixpkgs. Haskell packaging code, like `haskellPackages.mkDerivation`, `ghcWithPackages` and `hoogleWithPackages`, also no longer supports GHCJS.

- GHC 8.6, 8.10, 9.0, 9.2, and their package sets have been removed.

- Support for bootstrapping native GHC compilers on 32‐bit ARM and little‐endian 64‐bit PowerPC has been dropped.
  The latter was probably broken anyway.
  If there is interest in restoring support for these architectures, it should be possible to cross‐compile a bootstrap GHC binary.

- `haskellPackages` and the package sets under `haskell.packages` no longer expose an `llvmPackages` attribute,
  though it can still be accessed via `ghc.llvmPackages` (from the same package set).
  Haskell packages usually only need to depend on an LLVM version matching GHC if they force the use the LLVM
  backend even if NCG is available. In this case, it is best to use the `forceLlvmCodegenBackend` helper.
  In all other cases, like linking against `libLLVM`, Haskell packages should use the appropriate version of `llvmPackages` from `pkgs`.

- `uw-ttyp0` has been updated to version 2.1. The filenames of the OTB and PSF fonts have been changed to match the upstream naming convention.
  If you were loading a font by path, for example in the `console.font` NixOS option, remember to update the filename accordingly.

- `adminneo` has been updated to version 5.1.1. Version 5 breaks compatibility with `adminer` and changes how plugins and configuration work. See the [Upgrade Guide](https://www.adminneo.org/upgrade#v5.0.0) for details. Those changes also led to changes in the arguments of the package.

- `base16-builder` node package has been removed due to lack of upstream maintenance.

- `python3Packages.bjoern` has been removed, as the upstream is unmaintained and it depends on a 14-year-old version of http-parser with numerous vulnerabilities.

- `buildGoModule` removes the compatibility layer of `CGO_ENABLED` not specified via `env`.
  Specifying `CGO_ENABLED` directly now results in an error.

- `buildGoModule` now warns if `<pkg>.passthru.overrideModAttrs` is lost during the overriding of its result packages.

- `gentium` package now provides `Gentium-*.ttf` files, and not `GentiumPlus-*.ttf` files like before. The font identifiers `Gentium Plus*` are available in the `gentium-plus` package, and if you want to use the more recently updated package `gentium` [by SIL](https://software.sil.org/gentium/), you should update your configuration files to use the `Gentium` font identifier.

- `space-orbit` package has been removed due to lack of upstream maintenance. Debian upstream stopped tracking it in 2011.

- Derivations setting both `separateDebugInfo` and one of `allowedReferences`, `allowedRequisites`, `disallowedReferences` or `disallowedRequisites` must now set `__structuredAttrs` to `true`. The effect of reference whitelisting or blacklisting will be disabled on the `debug` output created by `separateDebugInfo`.

- `k2pdfopt` has been removed, as it's broken.

- `victoriametrics` no longer contains VictoriaLogs components. These have been separated into the new package `victorialogs`.

- `mx-puppet-discord` was removed from Nixpkgs along with its NixOS module as it was unmaintained and was the only user of sha1 hashes in tree.

- `gradience` has been removed because it was archived upstream.

- `kbd` package's `outputs` now include a `man` and `scripts` outputs. The `unicode_start` and `unicode_stop` Bash scripts are now part of the `scripts` output, allowing most usages of the `kbd` package to not pull in `bash`.

- `spidermonkey_91` has been removed, as it has been EOL since September 2022.

- `hiawata` has been removed, due to lack of active development upstream, lack of maintainership downstream and upcoming security issues.

- `forgejo` main program has been renamed to `bin/forgejo` from the previous `bin/gitea`.

- `cudaPackages.cudatoolkit-legacy-runfile` has been removed.

- `conduwuit` was removed due to upstream ceasing development and deleting their repository. For existing data, a migration to `matrix-conduit`, `matrix-continuwuity` or `matrix-tuwunel` may be possible.

- The `ghcInfo` and `controlPhases` functions have been removed from `haskell.lib.compose` and `haskell.lib`. They were unused and would return incorrect results.

  - Instead of using `controlPhases`, the `doCheck` attribute of derivations can be accessed which is more accurate. `doBenchmark` can't be introspected at the moment.
  - To detect cross compilation, the relevant platforms exposed by `stdenv` should be compared instead of using `ghcInfo`.
  - Nixpkgs no longer packages any `ghcjs` compiler.
  - To find a suitable `nativeGhc`, `buildHaskellPackages` should be used. `ghcInfo` would use `ghc.bootPkgs.ghc` if cross compiling,
    and the given `ghc` otherwise. This approach is not recommended since it results in mismatched GHC versions.

- `gnome-keyring` no longer ships with an SSH agent anymore because it has been deprecated upstream. You should use `gcr_4` instead, which provides the same features. More information on why this was done can be found on [the relevant GCR upstream PR](https://gitlab.gnome.org/GNOME/gcr/-/merge_requests/67).

- `python3Full` and its versioned attributes (python3xxFull) have been removed. Bluetooth support is now enabled in the default python3 attributes. The X11 support built the tkinter module, which is available as a dedicated attribute on the package set.

- `stdenv.mkDerivation` and other derivation builders that use it no longer allow the value of `env` to be anything but an attribute set, for the purpose of setting environment variables that are available to the [builder](https://nix.dev/manual/nix/latest/store/derivation/#builder) process. An environment variable called `env` can still be provided by means of `mkDerivation { env.env = ...; }`, though we recommend to use a more specific name than "env".

- `purple-matrix` has been removed, since it has been unmaintained since April 2022 and upstream does not recommend using it anymore.

- `sublime-music` has been removed because upstream has announced it is no longer maintained. Upstream suggests using `supersonic` instead.

- The default Android NDK version has been raised to 27, and the default SDK version to 35.
  NDK 21–26 have been removed, as they are end‐of‐life.

- `nuget-to-nix` has been removed as it was deprecated in favor of `nuget-to-json`. Out-of-tree packages that were using `nuget-to-nix` should migrate to use `nuget-to-json` instead for generating .NET dependency lock files.

- `conftest` since `0.60.0` has moved to use rego `v1` as default. To continue using `v0` use `--rego-version v0`. For more information about upgrading to Rego v1 syntax, see the [upstream docs](https://www.openpolicyagent.org/docs/latest/v0-upgrade/).

- Zig 0.12 has been removed.

- `ansible-later` has been removed because it was discontinued by the author.

- `k3s` airgap images passthru attributes have changed:
  - `imagesList` was removed
  - `airgapImages` was renamed to `airgap-images`
  - `airgapImagesAmd64` was renamed to `airgap-images-amd64-tar-zst`
  - `airgapImagesArm64` was renamed to `airgap-images-arm64-tar-zst`
  - `airgapImagesArm` was renamed to `airgap-images-arm-tar-zst`

- `stalwart-mail` since `0.13.0` "introduces a significant redesign of the MTA’s delivery and queueing subsystem". See [the upgrading announcement for the `0.13.0` release](https://github.com/stalwartlabs/stalwart/blob/89b561b5ca1c5a11f2a768b4a2cfef0f473b7a01/UPGRADING.md#upgrading-from-v012x-and-v011x-to-v013x).

- `meilisearch_1_11` has been removed, as it is no longer supported.

- Greetd and its original greeters (`tuigreet`, `gtkgreet`, `qtgreet`, `regreet`, `wlgreet`) were moved from `greetd` namespace to top level (`greetd.tuigreet` -> `tuigreet`, `greetd.greetd` -> `greetd`, etc). The original attrs are available for compatibility as passthrus of `greetd`, but will emit a warning. They will be removed in future releases.

- The `archipelago-minecraft` package was removed, as upstream no longer provides support for the Minecraft APWorld.

- `pcp` has been removed because the upstream repo was archived and it hasn't been updated since 2021.

- `navidrome` 0.58.0 introduces [multi-library support](https://www.navidrome.org/docs/usage/multi-library/)
    and backwards incompatible database migrations. Ensure backups are valid and run a Full Scan after
    starting the new version.

- `tooling-language-server` has been renamed to `deputy` (both the package and binary), following the rename of the upstream project.

- `fetchFromBitBucket` has gained a `fetchgit` backend when passing in git-related arguments similar to `fetchFromGitHub`.

- `fetchtorrent`, when using the "rqbit" backend, erroneously started fetching files into a subdirectory in Nixpkgs 24.11.  The original behaviour &ndash; which matches the behaviour using the "transmission" backend &ndash; has now been restored.  Users reliant on the erroneous behaviour can temporarily maintain it by adding `flatten = false` to the `fetchtorrent` arguments; Nix will produce an evaluation warning for anyone using `backend = "rqbit"` without `flatten = true`.

- `steamcontroller` has been removed due to lack of upstream maintenance. Consider using `sc-controller` instead.

- `linux` and all other Linux kernel packages have moved all in-tree kernel modules into a new `modules` output.

- `webfontkitgenerator` has been renamed to `webfont-bundler`, following the rename of the upstream project.
  The binary name remains `webfontkitgenerator`.
  The `webfontkitgenerator` package is an alias to `webfont-bundler`.

- `python3Packages.triton` no longer takes an `enableRocm` argument and supports ROCm in all build configurations via runtime binding. In most cases no action will be needed. If triton is unable to find the HIP SDK add `rocmPackages.clr` as a build input or set the environment variable `HIP_PATH="${rocmPackages.clr}"`.

- `floorp` has been replaced with a binary build, available as `floorp-bin`. Due to major changes in the upstream project structure and build system, building Floorp from source has become unfeasible. No configuration or state migration is necessary.

- `inspircd` has been updated to the v4 release series. Please refer to the upstream documentation for [general information](https://docs.inspircd.org/4/overview/#v4-overview) and a list of [breaking changes](https://docs.inspircd.org/4/breaking-changes/).

- `proton-caller` has been removed due to lack of upstream maintenance.

- `lima` package now only includes the guest agent for the host's architecture by default. If your guest VM's architecture differs from your Lima host's, you'll need to enable the `lima-additional-guestagents` package by setting `withAdditionalGuestAgents = true` when overriding lima with this input.

- `mongodb-6_0` was removed as it is end of life as of 2025-07-31.

- CUDA versions below 12.6 have been removed, as they are unmaintained upstream and depend on end‐of‐life compilers.

- `vmware-horizon-client` was renamed to `omnissa-horizon-client`, following [VMware's sale of their end-user business to Omnissa](https://www.omnissa.com/insights/introducing-omnissa-the-former-vmware-end-user-computing-business/). The binary has been renamed from `vmware-view` to `horizon-client`.

- `neovimUtils.makeNeovimConfig` now uses `customLuaRC` parameter instead of accepting `luaRcContent`. The old usage is deprecated but still works with a warning.

- `python3Packages.pyocr` no longer supports `cuneiform` on Linux by default. It is still possible to enable it using `withCuneiformSupport` override.

- `telegram-desktop` packages now uses `Telegram` for its binary. The previous name was `telegram-desktop`. This is due to [an upstream decision](https://github.com/telegramdesktop/tdesktop/commit/56ff5808a3d766f892bc3c3305afb106b629ef6f) to make the name consistent with other platforms.

- `hsd` has been upgraded to version 8. See [their changelog](https://github.com/handshake-org/hsd/blob/v8.0.0/docs/release-notes/release-notes-8.x.md) for important instructions before upgrading.

- `podofo` has been updated from `0.9.8` to `1.0.0`. These releases are by nature very incompatible due to major API changes. The legacy versions can be found under `podofo_0_10` and `podofo_0_9`.
  Changelog: https://github.com/podofo/podofo/blob/1.0.0/CHANGELOG.md, API-Migration-Guide: https://github.com/podofo/podofo/blob/1.0.0/API-MIGRATION.md.

- NetBox was updated to `>= 4.3.0`. Have a look at the breaking changes
  of the [4.3 release](https://github.com/netbox-community/netbox/releases/tag/v4.2.0),
  make the required changes to your database, if needed, then upgrade by setting `services.netbox.package = pkgs.netbox_4_3;` in your configuration.

- `pkgs.nextcloud30` has been removed since it's out of support upstream.

- `privatebin` has been updated to `2.0.0`. This release changes configuration defaults including switching the template and removing legacy features. See the [v2.0.0 changelog entry](https://github.com/PrivateBin/PrivateBin/releases/tag/2.0.0) for details on how to upgrade.

- `rocmPackages.triton` has been removed in favor of `python3Packages.triton`.

- `linpinyin`, which is used for Chinese character input, has migrated from the unmaintained BDB database format to the newer KyotoCabinet database format. If you want to migrate your user input statistics you can consider using [bdbtokyotodb](https://codeberg.org/raboof/bdbtokyotodb).

- `go-mockery` has been updated to v3. For migration instructions see the [upstream documentation](https://vektra.github.io/mockery/latest/v3/). If v2 is still required `go-mockery_v2` has been added but will be removed on or before 2029-12-31 in-line with its [upstream support lifecycle](https://vektra.github.io/mockery/)

- `prometheus-script-exporter` has been updated to use a new maintained alternative. This release updates from `1.2.0 -> 3.0.1` and largely changes configuration options formats from json to yaml, among other changes.

- [private-gpt](https://github.com/zylon-ai/private-gpt) service has been removed by lack of maintenance upstream.

- `lxde` scope has been removed, and its packages have been moved the top-level.

- `pulsemeeter` has been updated to `2.0.0`. The configuration file from older versions has to be deleted. For more information and instructions see the [v2.0.0 changelog entry](https://github.com/theRealCarneiro/pulsemeeter/releases/tag/v2.0.0).

- `rofi` has been updated to `2.0.0`. `rofi-wayland` and `rofi-wayland-unwrapped` have been merged into `rofi` and `rofi-unwrapped` respectively. For more information and instructions see the [v2.0.0 changelog entry](https://github.com/davatorium/rofi/releases/tag/2.0.0).

- `rofi-emoji-wayland` has been merged into `rofi-emoji` as `rofi` has been updated to `2.0.0` and supports both X11 & Wayland.

- The main binary of `tomlq` has been renamed from `tomlq` to `tq`.

- `emacs-macport` has been moved to a fork of Mitsuharu Yamamoto's patched source code starting with Emacs v30 as the original project seems to be currently dormant. All older versions of this package have been dropped.
  This introduces some backwards‐incompatible changes; see the NEWS for details.
  NEWS can be viewed from Emacs by typing `C-h n`, or by clicking `Help->Emacs News` from the menu bar.
  It can also be browsed [online](https://git.savannah.gnu.org/cgit/emacs.git/tree/etc/NEWS?h=emacs-30).

- `python3Packages.heif-image-plugin` has been dropped due to lack of upstream maintenance and breakage. Use `python3Packages.pillow-heif` instead.

- `python3Packages.pyheif` has been dropped due to lack of upstream maintenance and breakage. Use `python3Packages.pillow-heif` instead.

- `nodePackages.rimraf` has been removed, as it is a Javascript library, and packages that want to use it should depend directly on it instead.

## Other Notable Changes {#sec-nixpkgs-release-25.11-notable-changes}

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

- Added `rewriteURL` attribute to the nixpkgs `config`, to allow for rewriting the URLs downloaded by `fetchurl`.
- Added `hashedMirrors` attribute to the nixpkgs `config`, to allow for customization of the hashed mirrors used by `fetchurl`.

- Added `gitConfig` and `gitConfigFile` option to the nixpkgs `config`, to allow for setting a default `gitConfigFile` for all `fetchgit` invocations.

- The `dockerTools.streamLayeredImage` builder now uses a better algorithm for generating layered docker images, such that much more sharing is possible when the number of store paths exceeds the layer limit. It gives each of the largest store paths its own layer and adds dependencies to those layers when they aren't used elsewhere.

- The systemd initrd will now respect `x-systemd.wants` and `x-systemd.requires` for reliably unlocking multi-disk bcachefs volumes.

- [`homebox` 0.20.0](https://github.com/sysadminsmedia/homebox/releases/tag/v0.20.0) changed how assets are stored and hashed. It is recommended to back up your database before this update. In particular, `--storage-data` was replaced with `--storage-conn-string` and `--storage-prefix-path`. If your configuration set `HBOX_STORAGE_DATA` manually, you must migrate it to `HBOX_STORAGE_CONN_STRING` and `HBOX_STORAGE_PREFIX_PATH`.

- GIMP now defaults to version 3. Use `gimp2` for the old version.

- `installShellCompletion`: now supports Nushell completion files

- New hardening flags, `strictflexarrays1` and `strictflexarrays3` were made available, corresponding to the gcc/clang options `-fstrict-flex-arrays=1` and `-fstrict-flex-arrays=3` respectively.

- `gramps` has been updated to 6.0.0
  Upstream recommends [backing up your Family Trees](https://gramps-project.org/wiki/index.php/Gramps_6.0_Wiki_Manual_-_Manage_Family_Trees#Backing_up_a_Family_Tree) before upgrading.

- `meta.mainProgram`: Changing this `meta` entry can lead to a package rebuild due to being used to determine the `NIX_MAIN_PROGRAM` environment variable.

- `forgejo-runner`: The upgrade to version 11 brings a license change from MIT to GPLv3-or-later.

- `lisp-modules` were brought in sync with the [June 2025 Quicklisp release](http://blog.quicklisp.org/2025/07/june-2025-quicklisp-dist-now-available.html).

- `ffmpeg_8`, `ffmpeg_8-headless`, and `ffmpeg_8-full` have been added. The default version of FFmpeg remains ffmpeg_7 for now, though this may change before release.

- `searx` was updated to use `envsubst` instead of `sed` for parsing secrets from environment variables.
  If your previous configuration included a secret reference like `server.secret_key = "@SEARX_SECRET_KEY@"`, you must migrate to the new envsubst syntax: `server.secret_key = "$SEARX_SECRET_KEY"`.

- A new hardening flag, `glibcxxassertions` was made available, corresponding to the glibc `_GLIBCXX_ASSERTIONS` option.

- `versionCheckHook`: Packages that previously relied solely on `pname` to locate the program used to version check, but have a differing `meta.mainProgram` entry, might now fail.


- The debug outputs produced by `separateDebugInfo = true;` now contain symlinks mapping build-ids to the original source and ELF file.
  Specifically, if `$out/bin/ninja` has build-id `483bd7f7229bdb06462222e1e353e4f37e15c293`, then
  * `$debug/lib/debug/.build-id/48/3bd7f7229bdb06462222e1e353e4f37e15c293.executable` is a symlink to `$out/bin/ninja`
  * `$debug/lib/debug/.build-id/48/3bd7f7229bdb06462222e1e353e4f37e15c293.source` is a symlink to the value of `$src` during build
  * `$debug/lib/debug/.build-id/48/3bd7f7229bdb06462222e1e353e4f37e15c293.sourceoverlay` is a symlink to a directory with the same structure as the expanded `$sourceRoot` but containing only a copy of files which were patched during the build
  * `$debug/lib/debug/.build-id/48/3bd7f7229bdb06462222e1e353e4f37e15c293.debug` is the file containing debug symbols (like before).

- `fetchgit`: Add `gitConfigFile` argument to set a git config (via `$GIT_CONFIG_GLOBAL`) for the fetcher.

- `fetchgit`: Add `rootDir` argument to limit the resulting source to one subdirectory of the whole Git repository. Corresponding `--root-dir` option added to `nix-prefetch-git`.

- `nix-prefetch-git`: Added a `--no-add-path` argument to disable adding the path to the store; this is useful when working with a [read-only store](https://nix.dev/manual/nix/2.28/command-ref/new-cli/nix3-help-stores#store-experimental-local-overlay-store-read-only).

- `sftpman` has been updated to version 2, a rewrite in Rust which is mostly backward compatible but does include some changes to the CLI.
  For more information, [check the project's README](https://github.com/spantaleev/sftpman-rs#is-sftpman-v2-compatible-with-sftpman-v1).

- The `clickhouse` package now track the stable upstream version per [upstream's
  recommendation](https://clickhouse.com/docs/faq/operations/production). Users
  can continue to use the `clickhouse-lts` package if desired.

- `emacs` now disables the GC mark trace buffer by default. This improves GC performance by 5%, but can make GC issues harder to debug. This is configurable with `withGcMarkTrace`.

- `buildPythonPackage` and `buildPythonApplication` now default to `nix-update-script` as their default `updateScript`. This should improve automated updates, since nix-update is better maintained than the in-tree update script and has more robust fetcher support.

## Nixpkgs Library {#sec-nixpkgs-release-25.11-lib}

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

- `mealie` has been updated to 3.0.2: This update introduces breaking changes in some API endpoints (see the [release changelog](https://github.com/mealie-recipes/mealie/releases/tag/v3.0.0)).

### Breaking changes {#sec-nixpkgs-release-25.11-lib-breaking}

- `reaction` has been updated to version 2, which includes some breaking changes.
  For more information, [check the release article](https://blog.ppom.me/en-reaction-v2).

- `lib.options.mkPackageOptionMD` has been removed, following its deprecation in NixOS 24.11. Use `lib.options.mkPackageOption` instead.

- The `buildPythonPackage` and `buildPythonApplication` functions now require
  an explicit `format` attribute. Previously the default format used setuptools
  and called `setup.py` from the source tree, which is deprecated.
  The modern alternative is to configure `pyproject = true` with `build-system = [ setuptools ]`.

- `boot.enableContainers` is only turned on when a declarative NixOS container is defined in `containers`.
  If you use the `nixos-container` tool for imperative container management, set `boot.enableContainers = true;` explicitly.

### Deprecations {#sec-nixpkgs-release-25.11-lib-deprecations}

- `types.either` silently accepted mismatching types when used in `freeformType`. Module maintainers should fix the used type
  In most cases wrapping `either` with `attrsOf` should be sufficient.

  Since types.either was used to bootstrap other types. This also affects the following types:
  - `oneOf`
  - `number`
  - `numbers.*`

### Additions and Improvements {#sec-nixpkgs-release-25.11-lib-additions-improvements}

- `neovim`: Added support for the `vim.o.exrc` option, the `VIMINIT` environment variable, and sourcing of `sysinit.vim`.

  See the neovim help page [`:help startup`](https://neovim.io/doc/user/starting.html#startup) for more information, as well as [the nixpkgs neovim wrapper documentation](#neovim-custom-configuration).

- `cloudflare-ddns`: Added package cloudflare-ddns.

- `nextcloud32`: Added for the Nextcloud 32 major release.

  See https://nextcloud.com/blog/nextcloud-hub25-autumn/ for more details on the new major version.
