require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_ASM_X86_KVM_H)) {
    eval 'sub _ASM_X86_KVM_H () {1;}' unless defined(&_ASM_X86_KVM_H);
    require 'linux/const.ph';
    require 'linux/bits.ph';
    require 'linux/types.ph';
    require 'linux/ioctl.ph';
    require 'linux/stddef.ph';
    eval 'sub KVM_PIO_PAGE_OFFSET () {1;}' unless defined(&KVM_PIO_PAGE_OFFSET);
    eval 'sub KVM_COALESCED_MMIO_PAGE_OFFSET () {2;}' unless defined(&KVM_COALESCED_MMIO_PAGE_OFFSET);
    eval 'sub KVM_DIRTY_LOG_PAGE_OFFSET () {64;}' unless defined(&KVM_DIRTY_LOG_PAGE_OFFSET);
    eval 'sub DE_VECTOR () {0;}' unless defined(&DE_VECTOR);
    eval 'sub DB_VECTOR () {1;}' unless defined(&DB_VECTOR);
    eval 'sub BP_VECTOR () {3;}' unless defined(&BP_VECTOR);
    eval 'sub OF_VECTOR () {4;}' unless defined(&OF_VECTOR);
    eval 'sub BR_VECTOR () {5;}' unless defined(&BR_VECTOR);
    eval 'sub UD_VECTOR () {6;}' unless defined(&UD_VECTOR);
    eval 'sub NM_VECTOR () {7;}' unless defined(&NM_VECTOR);
    eval 'sub DF_VECTOR () {8;}' unless defined(&DF_VECTOR);
    eval 'sub TS_VECTOR () {10;}' unless defined(&TS_VECTOR);
    eval 'sub NP_VECTOR () {11;}' unless defined(&NP_VECTOR);
    eval 'sub SS_VECTOR () {12;}' unless defined(&SS_VECTOR);
    eval 'sub GP_VECTOR () {13;}' unless defined(&GP_VECTOR);
    eval 'sub PF_VECTOR () {14;}' unless defined(&PF_VECTOR);
    eval 'sub MF_VECTOR () {16;}' unless defined(&MF_VECTOR);
    eval 'sub AC_VECTOR () {17;}' unless defined(&AC_VECTOR);
    eval 'sub MC_VECTOR () {18;}' unless defined(&MC_VECTOR);
    eval 'sub XM_VECTOR () {19;}' unless defined(&XM_VECTOR);
    eval 'sub VE_VECTOR () {20;}' unless defined(&VE_VECTOR);
    eval 'sub __KVM_HAVE_PIT () {1;}' unless defined(&__KVM_HAVE_PIT);
    eval 'sub __KVM_HAVE_IOAPIC () {1;}' unless defined(&__KVM_HAVE_IOAPIC);
    eval 'sub __KVM_HAVE_IRQ_LINE () {1;}' unless defined(&__KVM_HAVE_IRQ_LINE);
    eval 'sub __KVM_HAVE_MSI () {1;}' unless defined(&__KVM_HAVE_MSI);
    eval 'sub __KVM_HAVE_USER_NMI () {1;}' unless defined(&__KVM_HAVE_USER_NMI);
    eval 'sub __KVM_HAVE_MSIX () {1;}' unless defined(&__KVM_HAVE_MSIX);
    eval 'sub __KVM_HAVE_MCE () {1;}' unless defined(&__KVM_HAVE_MCE);
    eval 'sub __KVM_HAVE_PIT_STATE2 () {1;}' unless defined(&__KVM_HAVE_PIT_STATE2);
    eval 'sub __KVM_HAVE_XEN_HVM () {1;}' unless defined(&__KVM_HAVE_XEN_HVM);
    eval 'sub __KVM_HAVE_VCPU_EVENTS () {1;}' unless defined(&__KVM_HAVE_VCPU_EVENTS);
    eval 'sub __KVM_HAVE_DEBUGREGS () {1;}' unless defined(&__KVM_HAVE_DEBUGREGS);
    eval 'sub __KVM_HAVE_XSAVE () {1;}' unless defined(&__KVM_HAVE_XSAVE);
    eval 'sub __KVM_HAVE_XCRS () {1;}' unless defined(&__KVM_HAVE_XCRS);
    eval 'sub KVM_NR_INTERRUPTS () {256;}' unless defined(&KVM_NR_INTERRUPTS);
    eval 'sub KVM_IOAPIC_NUM_PINS () {24;}' unless defined(&KVM_IOAPIC_NUM_PINS);
    eval 'sub KVM_IRQCHIP_PIC_MASTER () {0;}' unless defined(&KVM_IRQCHIP_PIC_MASTER);
    eval 'sub KVM_IRQCHIP_PIC_SLAVE () {1;}' unless defined(&KVM_IRQCHIP_PIC_SLAVE);
    eval 'sub KVM_IRQCHIP_IOAPIC () {2;}' unless defined(&KVM_IRQCHIP_IOAPIC);
    eval 'sub KVM_NR_IRQCHIPS () {3;}' unless defined(&KVM_NR_IRQCHIPS);
    eval 'sub KVM_RUN_X86_SMM () {(1<< 0);}' unless defined(&KVM_RUN_X86_SMM);
    eval 'sub KVM_RUN_X86_BUS_LOCK () {(1<< 1);}' unless defined(&KVM_RUN_X86_BUS_LOCK);
    eval 'sub KVM_RUN_X86_GUEST_MODE () {(1<< 2);}' unless defined(&KVM_RUN_X86_GUEST_MODE);
    eval 'sub KVM_APIC_REG_SIZE () {0x400;}' unless defined(&KVM_APIC_REG_SIZE);
    eval 'sub KVM_SREGS2_FLAGS_PDPTRS_VALID () {1;}' unless defined(&KVM_SREGS2_FLAGS_PDPTRS_VALID);
    eval 'sub KVM_MSR_FILTER_MAX_BITMAP_SIZE () {0x600;}' unless defined(&KVM_MSR_FILTER_MAX_BITMAP_SIZE);
    eval 'sub KVM_MSR_FILTER_READ () {(1<< 0);}' unless defined(&KVM_MSR_FILTER_READ);
    eval 'sub KVM_MSR_FILTER_WRITE () {(1<< 1);}' unless defined(&KVM_MSR_FILTER_WRITE);
    eval 'sub KVM_MSR_FILTER_RANGE_VALID_MASK () {( &KVM_MSR_FILTER_READ |  &KVM_MSR_FILTER_WRITE);}' unless defined(&KVM_MSR_FILTER_RANGE_VALID_MASK);
    eval 'sub KVM_MSR_FILTER_MAX_RANGES () {16;}' unless defined(&KVM_MSR_FILTER_MAX_RANGES);
    eval 'sub KVM_MSR_FILTER_DEFAULT_ALLOW () {(0<< 0);}' unless defined(&KVM_MSR_FILTER_DEFAULT_ALLOW);
    eval 'sub KVM_MSR_FILTER_DEFAULT_DENY () {(1<< 0);}' unless defined(&KVM_MSR_FILTER_DEFAULT_DENY);
    eval 'sub KVM_MSR_FILTER_VALID_MASK () {( &KVM_MSR_FILTER_DEFAULT_DENY);}' unless defined(&KVM_MSR_FILTER_VALID_MASK);
    eval 'sub KVM_CPUID_FLAG_SIGNIFCANT_INDEX () {(1<< 0);}' unless defined(&KVM_CPUID_FLAG_SIGNIFCANT_INDEX);
    eval 'sub KVM_CPUID_FLAG_STATEFUL_FUNC () {(1<< 1);}' unless defined(&KVM_CPUID_FLAG_STATEFUL_FUNC);
    eval 'sub KVM_CPUID_FLAG_STATE_READ_NEXT () {(1<< 2);}' unless defined(&KVM_CPUID_FLAG_STATE_READ_NEXT);
    eval 'sub KVM_GUESTDBG_USE_SW_BP () {0x10000;}' unless defined(&KVM_GUESTDBG_USE_SW_BP);
    eval 'sub KVM_GUESTDBG_USE_HW_BP () {0x20000;}' unless defined(&KVM_GUESTDBG_USE_HW_BP);
    eval 'sub KVM_GUESTDBG_INJECT_DB () {0x40000;}' unless defined(&KVM_GUESTDBG_INJECT_DB);
    eval 'sub KVM_GUESTDBG_INJECT_BP () {0x80000;}' unless defined(&KVM_GUESTDBG_INJECT_BP);
    eval 'sub KVM_GUESTDBG_BLOCKIRQ () {0x100000;}' unless defined(&KVM_GUESTDBG_BLOCKIRQ);
    eval 'sub KVM_PIT_FLAGS_HPET_LEGACY () {0x1;}' unless defined(&KVM_PIT_FLAGS_HPET_LEGACY);
    eval 'sub KVM_PIT_FLAGS_SPEAKER_DATA_ON () {0x2;}' unless defined(&KVM_PIT_FLAGS_SPEAKER_DATA_ON);
    eval 'sub KVM_VCPUEVENT_VALID_NMI_PENDING () {0x1;}' unless defined(&KVM_VCPUEVENT_VALID_NMI_PENDING);
    eval 'sub KVM_VCPUEVENT_VALID_SIPI_VECTOR () {0x2;}' unless defined(&KVM_VCPUEVENT_VALID_SIPI_VECTOR);
    eval 'sub KVM_VCPUEVENT_VALID_SHADOW () {0x4;}' unless defined(&KVM_VCPUEVENT_VALID_SHADOW);
    eval 'sub KVM_VCPUEVENT_VALID_SMM () {0x8;}' unless defined(&KVM_VCPUEVENT_VALID_SMM);
    eval 'sub KVM_VCPUEVENT_VALID_PAYLOAD () {0x10;}' unless defined(&KVM_VCPUEVENT_VALID_PAYLOAD);
    eval 'sub KVM_VCPUEVENT_VALID_TRIPLE_FAULT () {0x20;}' unless defined(&KVM_VCPUEVENT_VALID_TRIPLE_FAULT);
    eval 'sub KVM_X86_SHADOW_INT_MOV_SS () {0x1;}' unless defined(&KVM_X86_SHADOW_INT_MOV_SS);
    eval 'sub KVM_X86_SHADOW_INT_STI () {0x2;}' unless defined(&KVM_X86_SHADOW_INT_STI);
    eval 'sub KVM_MAX_XCRS () {16;}' unless defined(&KVM_MAX_XCRS);
    eval 'sub KVM_SYNC_X86_REGS () {(1 << 0);}' unless defined(&KVM_SYNC_X86_REGS);
    eval 'sub KVM_SYNC_X86_SREGS () {(1 << 1);}' unless defined(&KVM_SYNC_X86_SREGS);
    eval 'sub KVM_SYNC_X86_EVENTS () {(1 << 2);}' unless defined(&KVM_SYNC_X86_EVENTS);
    eval 'sub KVM_SYNC_X86_VALID_FIELDS () {( &KVM_SYNC_X86_REGS|  &KVM_SYNC_X86_SREGS|  &KVM_SYNC_X86_EVENTS);}' unless defined(&KVM_SYNC_X86_VALID_FIELDS);
    eval 'sub KVM_X86_QUIRK_LINT0_REENABLED () {(1<< 0);}' unless defined(&KVM_X86_QUIRK_LINT0_REENABLED);
    eval 'sub KVM_X86_QUIRK_CD_NW_CLEARED () {(1<< 1);}' unless defined(&KVM_X86_QUIRK_CD_NW_CLEARED);
    eval 'sub KVM_X86_QUIRK_LAPIC_MMIO_HOLE () {(1<< 2);}' unless defined(&KVM_X86_QUIRK_LAPIC_MMIO_HOLE);
    eval 'sub KVM_X86_QUIRK_OUT_7E_INC_RIP () {(1<< 3);}' unless defined(&KVM_X86_QUIRK_OUT_7E_INC_RIP);
    eval 'sub KVM_X86_QUIRK_MISC_ENABLE_NO_MWAIT () {(1<< 4);}' unless defined(&KVM_X86_QUIRK_MISC_ENABLE_NO_MWAIT);
    eval 'sub KVM_X86_QUIRK_FIX_HYPERCALL_INSN () {(1<< 5);}' unless defined(&KVM_X86_QUIRK_FIX_HYPERCALL_INSN);
    eval 'sub KVM_X86_QUIRK_MWAIT_NEVER_UD_FAULTS () {(1<< 6);}' unless defined(&KVM_X86_QUIRK_MWAIT_NEVER_UD_FAULTS);
    eval 'sub KVM_X86_QUIRK_SLOT_ZAP_ALL () {(1<< 7);}' unless defined(&KVM_X86_QUIRK_SLOT_ZAP_ALL);
    eval 'sub KVM_X86_QUIRK_STUFF_FEATURE_MSRS () {(1<< 8);}' unless defined(&KVM_X86_QUIRK_STUFF_FEATURE_MSRS);
    eval 'sub KVM_STATE_NESTED_FORMAT_VMX () {0;}' unless defined(&KVM_STATE_NESTED_FORMAT_VMX);
    eval 'sub KVM_STATE_NESTED_FORMAT_SVM () {1;}' unless defined(&KVM_STATE_NESTED_FORMAT_SVM);
    eval 'sub KVM_STATE_NESTED_GUEST_MODE () {0x1;}' unless defined(&KVM_STATE_NESTED_GUEST_MODE);
    eval 'sub KVM_STATE_NESTED_RUN_PENDING () {0x2;}' unless defined(&KVM_STATE_NESTED_RUN_PENDING);
    eval 'sub KVM_STATE_NESTED_EVMCS () {0x4;}' unless defined(&KVM_STATE_NESTED_EVMCS);
    eval 'sub KVM_STATE_NESTED_MTF_PENDING () {0x8;}' unless defined(&KVM_STATE_NESTED_MTF_PENDING);
    eval 'sub KVM_STATE_NESTED_GIF_SET () {0x100;}' unless defined(&KVM_STATE_NESTED_GIF_SET);
    eval 'sub KVM_STATE_NESTED_SMM_GUEST_MODE () {0x1;}' unless defined(&KVM_STATE_NESTED_SMM_GUEST_MODE);
    eval 'sub KVM_STATE_NESTED_SMM_VMXON () {0x2;}' unless defined(&KVM_STATE_NESTED_SMM_VMXON);
    eval 'sub KVM_STATE_NESTED_VMX_VMCS_SIZE () {0x1000;}' unless defined(&KVM_STATE_NESTED_VMX_VMCS_SIZE);
    eval 'sub KVM_STATE_NESTED_SVM_VMCB_SIZE () {0x1000;}' unless defined(&KVM_STATE_NESTED_SVM_VMCB_SIZE);
    eval 'sub KVM_STATE_VMX_PREEMPTION_TIMER_DEADLINE () {0x1;}' unless defined(&KVM_STATE_VMX_PREEMPTION_TIMER_DEADLINE);
    eval 'sub KVM_X86_GRP_SYSTEM () {0;}' unless defined(&KVM_X86_GRP_SYSTEM);
    eval 'sub KVM_X86_XCOMP_GUEST_SUPP () {0;}' unless defined(&KVM_X86_XCOMP_GUEST_SUPP);
    eval 'sub KVM_X86_GRP_SEV () {1;}' unless defined(&KVM_X86_GRP_SEV);
    eval 'sub KVM_X86_SEV_VMSA_FEATURES () {0;}' unless defined(&KVM_X86_SEV_VMSA_FEATURES);
    eval 'sub KVM_PMU_EVENT_ALLOW () {0;}' unless defined(&KVM_PMU_EVENT_ALLOW);
    eval 'sub KVM_PMU_EVENT_DENY () {1;}' unless defined(&KVM_PMU_EVENT_DENY);
    eval 'sub KVM_PMU_EVENT_FLAG_MASKED_EVENTS () { &_BITUL(0);}' unless defined(&KVM_PMU_EVENT_FLAG_MASKED_EVENTS);
    eval 'sub KVM_PMU_EVENT_FLAGS_VALID_MASK () {( &KVM_PMU_EVENT_FLAG_MASKED_EVENTS);}' unless defined(&KVM_PMU_EVENT_FLAGS_VALID_MASK);
    eval 'sub KVM_XEN_HVM_CONFIG_HYPERCALL_MSR () {(1<< 0);}' unless defined(&KVM_XEN_HVM_CONFIG_HYPERCALL_MSR);
    eval 'sub KVM_XEN_HVM_CONFIG_INTERCEPT_HCALL () {(1<< 1);}' unless defined(&KVM_XEN_HVM_CONFIG_INTERCEPT_HCALL);
    eval 'sub KVM_XEN_HVM_CONFIG_SHARED_INFO () {(1<< 2);}' unless defined(&KVM_XEN_HVM_CONFIG_SHARED_INFO);
    eval 'sub KVM_XEN_HVM_CONFIG_RUNSTATE () {(1<< 3);}' unless defined(&KVM_XEN_HVM_CONFIG_RUNSTATE);
    eval 'sub KVM_XEN_HVM_CONFIG_EVTCHN_2LEVEL () {(1<< 4);}' unless defined(&KVM_XEN_HVM_CONFIG_EVTCHN_2LEVEL);
    eval 'sub KVM_XEN_HVM_CONFIG_EVTCHN_SEND () {(1<< 5);}' unless defined(&KVM_XEN_HVM_CONFIG_EVTCHN_SEND);
    eval 'sub KVM_XEN_HVM_CONFIG_RUNSTATE_UPDATE_FLAG () {(1<< 6);}' unless defined(&KVM_XEN_HVM_CONFIG_RUNSTATE_UPDATE_FLAG);
    eval 'sub KVM_XEN_HVM_CONFIG_PVCLOCK_TSC_UNSTABLE () {(1<< 7);}' unless defined(&KVM_XEN_HVM_CONFIG_PVCLOCK_TSC_UNSTABLE);
    eval 'sub KVM_XEN_HVM_CONFIG_SHARED_INFO_HVA () {(1<< 8);}' unless defined(&KVM_XEN_HVM_CONFIG_SHARED_INFO_HVA);
    eval 'sub KVM_XEN_MSR_MIN_INDEX () {0x40000000;}' unless defined(&KVM_XEN_MSR_MIN_INDEX);
    eval 'sub KVM_XEN_MSR_MAX_INDEX () {0x4fffffff;}' unless defined(&KVM_XEN_MSR_MAX_INDEX);
    eval 'sub KVM_XEN_INVALID_GFN () {(( &__u64)-1);}' unless defined(&KVM_XEN_INVALID_GFN);
    eval 'sub KVM_XEN_EVTCHN_DEASSIGN () {(1<< 0);}' unless defined(&KVM_XEN_EVTCHN_DEASSIGN);
    eval 'sub KVM_XEN_EVTCHN_UPDATE () {(1<< 1);}' unless defined(&KVM_XEN_EVTCHN_UPDATE);
    eval 'sub KVM_XEN_EVTCHN_RESET () {(1<< 2);}' unless defined(&KVM_XEN_EVTCHN_RESET);
    eval 'sub KVM_XEN_ATTR_TYPE_LONG_MODE () {0x;}' unless defined(&KVM_XEN_ATTR_TYPE_LONG_MODE);
    eval 'sub KVM_XEN_ATTR_TYPE_SHARED_INFO () {0x1;}' unless defined(&KVM_XEN_ATTR_TYPE_SHARED_INFO);
    eval 'sub KVM_XEN_ATTR_TYPE_UPCALL_VECTOR () {0x2;}' unless defined(&KVM_XEN_ATTR_TYPE_UPCALL_VECTOR);
    eval 'sub KVM_XEN_ATTR_TYPE_EVTCHN () {0x3;}' unless defined(&KVM_XEN_ATTR_TYPE_EVTCHN);
    eval 'sub KVM_XEN_ATTR_TYPE_XEN_VERSION () {0x4;}' unless defined(&KVM_XEN_ATTR_TYPE_XEN_VERSION);
    eval 'sub KVM_XEN_ATTR_TYPE_RUNSTATE_UPDATE_FLAG () {0x5;}' unless defined(&KVM_XEN_ATTR_TYPE_RUNSTATE_UPDATE_FLAG);
    eval 'sub KVM_XEN_ATTR_TYPE_SHARED_INFO_HVA () {0x6;}' unless defined(&KVM_XEN_ATTR_TYPE_SHARED_INFO_HVA);
    eval 'sub KVM_XEN_INVALID_GPA () {(( &__u64)-1);}' unless defined(&KVM_XEN_INVALID_GPA);
    eval 'sub KVM_XEN_VCPU_ATTR_TYPE_VCPU_INFO () {0x;}' unless defined(&KVM_XEN_VCPU_ATTR_TYPE_VCPU_INFO);
    eval 'sub KVM_XEN_VCPU_ATTR_TYPE_VCPU_TIME_INFO () {0x1;}' unless defined(&KVM_XEN_VCPU_ATTR_TYPE_VCPU_TIME_INFO);
    eval 'sub KVM_XEN_VCPU_ATTR_TYPE_RUNSTATE_ADDR () {0x2;}' unless defined(&KVM_XEN_VCPU_ATTR_TYPE_RUNSTATE_ADDR);
    eval 'sub KVM_XEN_VCPU_ATTR_TYPE_RUNSTATE_CURRENT () {0x3;}' unless defined(&KVM_XEN_VCPU_ATTR_TYPE_RUNSTATE_CURRENT);
    eval 'sub KVM_XEN_VCPU_ATTR_TYPE_RUNSTATE_DATA () {0x4;}' unless defined(&KVM_XEN_VCPU_ATTR_TYPE_RUNSTATE_DATA);
    eval 'sub KVM_XEN_VCPU_ATTR_TYPE_RUNSTATE_ADJUST () {0x5;}' unless defined(&KVM_XEN_VCPU_ATTR_TYPE_RUNSTATE_ADJUST);
    eval 'sub KVM_XEN_VCPU_ATTR_TYPE_VCPU_ID () {0x6;}' unless defined(&KVM_XEN_VCPU_ATTR_TYPE_VCPU_ID);
    eval 'sub KVM_XEN_VCPU_ATTR_TYPE_TIMER () {0x7;}' unless defined(&KVM_XEN_VCPU_ATTR_TYPE_TIMER);
    eval 'sub KVM_XEN_VCPU_ATTR_TYPE_UPCALL_VECTOR () {0x8;}' unless defined(&KVM_XEN_VCPU_ATTR_TYPE_UPCALL_VECTOR);
    eval 'sub KVM_XEN_VCPU_ATTR_TYPE_VCPU_INFO_HVA () {0x9;}' unless defined(&KVM_XEN_VCPU_ATTR_TYPE_VCPU_INFO_HVA);
    eval("sub KVM_SEV_INIT () { 0; }") unless defined(&KVM_SEV_INIT);
    eval("sub KVM_SEV_ES_INIT () { 1; }") unless defined(&KVM_SEV_ES_INIT);
    eval("sub KVM_SEV_LAUNCH_START () { 2; }") unless defined(&KVM_SEV_LAUNCH_START);
    eval("sub KVM_SEV_LAUNCH_UPDATE_DATA () { 3; }") unless defined(&KVM_SEV_LAUNCH_UPDATE_DATA);
    eval("sub KVM_SEV_LAUNCH_UPDATE_VMSA () { 4; }") unless defined(&KVM_SEV_LAUNCH_UPDATE_VMSA);
    eval("sub KVM_SEV_LAUNCH_SECRET () { 5; }") unless defined(&KVM_SEV_LAUNCH_SECRET);
    eval("sub KVM_SEV_LAUNCH_MEASURE () { 6; }") unless defined(&KVM_SEV_LAUNCH_MEASURE);
    eval("sub KVM_SEV_LAUNCH_FINISH () { 7; }") unless defined(&KVM_SEV_LAUNCH_FINISH);
    eval("sub KVM_SEV_SEND_START () { 8; }") unless defined(&KVM_SEV_SEND_START);
    eval("sub KVM_SEV_SEND_UPDATE_DATA () { 9; }") unless defined(&KVM_SEV_SEND_UPDATE_DATA);
    eval("sub KVM_SEV_SEND_UPDATE_VMSA () { 10; }") unless defined(&KVM_SEV_SEND_UPDATE_VMSA);
    eval("sub KVM_SEV_SEND_FINISH () { 11; }") unless defined(&KVM_SEV_SEND_FINISH);
    eval("sub KVM_SEV_RECEIVE_START () { 12; }") unless defined(&KVM_SEV_RECEIVE_START);
    eval("sub KVM_SEV_RECEIVE_UPDATE_DATA () { 13; }") unless defined(&KVM_SEV_RECEIVE_UPDATE_DATA);
    eval("sub KVM_SEV_RECEIVE_UPDATE_VMSA () { 14; }") unless defined(&KVM_SEV_RECEIVE_UPDATE_VMSA);
    eval("sub KVM_SEV_RECEIVE_FINISH () { 15; }") unless defined(&KVM_SEV_RECEIVE_FINISH);
    eval("sub KVM_SEV_GUEST_STATUS () { 16; }") unless defined(&KVM_SEV_GUEST_STATUS);
    eval("sub KVM_SEV_DBG_DECRYPT () { 17; }") unless defined(&KVM_SEV_DBG_DECRYPT);
    eval("sub KVM_SEV_DBG_ENCRYPT () { 18; }") unless defined(&KVM_SEV_DBG_ENCRYPT);
    eval("sub KVM_SEV_CERT_EXPORT () { 19; }") unless defined(&KVM_SEV_CERT_EXPORT);
    eval("sub KVM_SEV_GET_ATTESTATION_REPORT () { 20; }") unless defined(&KVM_SEV_GET_ATTESTATION_REPORT);
    eval("sub KVM_SEV_SEND_CANCEL () { 21; }") unless defined(&KVM_SEV_SEND_CANCEL);
    eval("sub KVM_SEV_INIT2 () { 22; }") unless defined(&KVM_SEV_INIT2);
    eval("sub KVM_SEV_SNP_LAUNCH_START () { 100; }") unless defined(&KVM_SEV_SNP_LAUNCH_START);
    eval("sub KVM_SEV_SNP_LAUNCH_UPDATE () { 101; }") unless defined(&KVM_SEV_SNP_LAUNCH_UPDATE);
    eval("sub KVM_SEV_SNP_LAUNCH_FINISH () { 102; }") unless defined(&KVM_SEV_SNP_LAUNCH_FINISH);
    eval("sub KVM_SEV_NR_MAX () { 103; }") unless defined(&KVM_SEV_NR_MAX);
    eval 'sub KVM_SEV_SNP_PAGE_TYPE_NORMAL () {0x1;}' unless defined(&KVM_SEV_SNP_PAGE_TYPE_NORMAL);
    eval 'sub KVM_SEV_SNP_PAGE_TYPE_ZERO () {0x3;}' unless defined(&KVM_SEV_SNP_PAGE_TYPE_ZERO);
    eval 'sub KVM_SEV_SNP_PAGE_TYPE_UNMEASURED () {0x4;}' unless defined(&KVM_SEV_SNP_PAGE_TYPE_UNMEASURED);
    eval 'sub KVM_SEV_SNP_PAGE_TYPE_SECRETS () {0x5;}' unless defined(&KVM_SEV_SNP_PAGE_TYPE_SECRETS);
    eval 'sub KVM_SEV_SNP_PAGE_TYPE_CPUID () {0x6;}' unless defined(&KVM_SEV_SNP_PAGE_TYPE_CPUID);
    eval 'sub KVM_SEV_SNP_ID_BLOCK_SIZE () {96;}' unless defined(&KVM_SEV_SNP_ID_BLOCK_SIZE);
    eval 'sub KVM_SEV_SNP_ID_AUTH_SIZE () {4096;}' unless defined(&KVM_SEV_SNP_ID_AUTH_SIZE);
    eval 'sub KVM_SEV_SNP_FINISH_DATA_SIZE () {32;}' unless defined(&KVM_SEV_SNP_FINISH_DATA_SIZE);
    eval 'sub KVM_X2APIC_API_USE_32BIT_IDS () {(1 << 0);}' unless defined(&KVM_X2APIC_API_USE_32BIT_IDS);
    eval 'sub KVM_X2APIC_API_DISABLE_BROADCAST_QUIRK () {(1 << 1);}' unless defined(&KVM_X2APIC_API_DISABLE_BROADCAST_QUIRK);
    eval 'sub KVM_HYPERV_CONN_ID_MASK () {0xffffff;}' unless defined(&KVM_HYPERV_CONN_ID_MASK);
    eval 'sub KVM_HYPERV_EVENTFD_DEASSIGN () {(1<< 0);}' unless defined(&KVM_HYPERV_EVENTFD_DEASSIGN);
    eval 'sub KVM_PMU_ENCODE_MASKED_ENTRY {
        my($event_select, $mask, $match, $exclude) = @_;
	    eval q(((($event_select) & 0xff) | ((($event_select) & 0xf00) << 24) | ((($mask) & 0xff) << 56) | ((($match) & 0xff) << 8) | (( &__u64)(!!($exclude)) << 55)));
    }' unless defined(&KVM_PMU_ENCODE_MASKED_ENTRY);
    eval 'sub KVM_PMU_MASKED_ENTRY_EVENT_SELECT () {( &__GENMASK_ULL(7, 0) |  &__GENMASK_ULL(35, 32));}' unless defined(&KVM_PMU_MASKED_ENTRY_EVENT_SELECT);
    eval 'sub KVM_PMU_MASKED_ENTRY_UMASK_MASK () {( &__GENMASK_ULL(63, 56));}' unless defined(&KVM_PMU_MASKED_ENTRY_UMASK_MASK);
    eval 'sub KVM_PMU_MASKED_ENTRY_UMASK_MATCH () {( &__GENMASK_ULL(15, 8));}' unless defined(&KVM_PMU_MASKED_ENTRY_UMASK_MATCH);
    eval 'sub KVM_PMU_MASKED_ENTRY_EXCLUDE () {( &_BITULL(55));}' unless defined(&KVM_PMU_MASKED_ENTRY_EXCLUDE);
    eval 'sub KVM_PMU_MASKED_ENTRY_UMASK_MASK_SHIFT () {(56);}' unless defined(&KVM_PMU_MASKED_ENTRY_UMASK_MASK_SHIFT);
    eval 'sub KVM_VCPU_TSC_CTRL () {0;}' unless defined(&KVM_VCPU_TSC_CTRL);
    eval 'sub KVM_VCPU_TSC_OFFSET () {0;}' unless defined(&KVM_VCPU_TSC_OFFSET);
    eval 'sub KVM_EXIT_HYPERCALL_LONG_MODE () { &_BITULL(0);}' unless defined(&KVM_EXIT_HYPERCALL_LONG_MODE);
    eval 'sub KVM_X86_DEFAULT_VM () {0;}' unless defined(&KVM_X86_DEFAULT_VM);
    eval 'sub KVM_X86_SW_PROTECTED_VM () {1;}' unless defined(&KVM_X86_SW_PROTECTED_VM);
    eval 'sub KVM_X86_SEV_VM () {2;}' unless defined(&KVM_X86_SEV_VM);
    eval 'sub KVM_X86_SEV_ES_VM () {3;}' unless defined(&KVM_X86_SEV_ES_VM);
    eval 'sub KVM_X86_SNP_VM () {4;}' unless defined(&KVM_X86_SNP_VM);
    eval 'sub KVM_X86_TDX_VM () {5;}' unless defined(&KVM_X86_TDX_VM);
}
1;
