{
  stdenv,
  lib,
  qt5,
  qtbase,
  qttools,
  qtwebsockets,
  qtmultimedia,
  fetchFromGitHub,
}:

stdenv.mkDerivation {
  pname = "r3ctl";
  version = "a82cb5b3123224e706835407f21acea9dc7ab0f0";

  src = fetchFromGitHub {
    owner = "0xfeedc0de64";
    repo = "r3ctl";
    rev = "a82cb5b3123224e706835407f21acea9dc7ab0f0";
    sha256 = "5/L8jvEDJGJzsuAxPrctSDS3d8lbFX/+f52OVyGQ/RY=";
  };

  buildPhase = ''
    qmake .
    make
  '';

  postInstall = ''
    mv bin $out
  '';

  nativeBuildInputs = [
    qt5.wrapQtAppsHook
  ];

  buildInputs = [
    qtbase
    qttools
    qtmultimedia
    qtwebsockets
  ];

  meta = {
    description = "Cmdline tool to control the r3 hackerspace lights";
    mainProgram = "r3ctl";
    homepage = "https://github.com/0xfeedc0de64/r3ctl";
    maintainers = with lib.maintainers; [ mkg20001 ];
    license = lib.licenses.gpl3Only;
    platforms = lib.platforms.linux;
  };
}
