{
  bootstrapTools,
  stdenv,
  pkgs,
  lib,
}:

# ordering should match defaultNativeBuildInputs

{
  no-broken-symlinks = lib.recurseIntoAttrs (
    import ./no-broken-symlinks.nix { inherit stdenv lib pkgs; }
  );
  # TODO: add audit-tmpdir
  compress-man-pages =
    let
      manFile = pkgs.writeText "small-man" ''
        .TH HELLO "1" "May 2022" "hello 2.12.1" "User Commands"
        .SH NAME
        hello - friendly greeting program
      '';
    in
    stdenv.mkDerivation {
      name = "test-compress-man-pages";
      buildCommand = ''
        mkdir -p $out/share/man
        cp ${manFile} $out/share/man/small-man.1
        compressManPages $out
        [[ -e $out/share/man/small-man.1.gz ]]
      '';
    };
  # test based on bootstrapTools to minimize rebuilds
  make-symlinks-relative =
    (derivation {
      name = "test-make-symlinks-relative";
      system = stdenv.system;
      builder = "${bootstrapTools}/bin/bash";
      initialPath = "${bootstrapTools}";
      outputs = [
        "out"
        "out2"
      ];
      args = [
        "-c"
        ''
          set -euo pipefail
          . ${../../stdenv/generic/setup.sh}
          . ${../../build-support/setup-hooks/make-symlinks-relative.sh}

          mkdir -p $out $out2

          # create symlink targets
          touch $out/target $out2/target

          # link within out
          ln -s $out/target $out/linkToOut

          # link across different outputs
          ln -s $out2/target $out/linkToOut2

          # broken link
          ln -s $out/does-not-exist $out/brokenLink

          # call hook
          _makeSymlinksRelative

          # verify link within out became relative
          echo "readlink linkToOut: $(readlink $out/linkToOut)"
          if test "$(readlink $out/linkToOut)" != 'target'; then
            echo "Expected relative link, got: $(readlink $out/linkToOut)"
            exit 1
          fi

          # verify link across outputs is still absolute
          if test "$(readlink $out/linkToOut2)" != "$out2/target"; then
            echo "Expected absolute link, got: $(readlink $out/linkToOut2)"
            exit 1
          fi

          # verify broken link was made relative
          if test "$(readlink $out/brokenLink)" != 'does-not-exist'; then
            echo "Expected relative broken link, got: $(readlink $out/brokenLink)"
            exit 1
          fi
        ''
      ];
    })
    // {
      meta = { };
    };
  move-docs = stdenv.mkDerivation {
    name = "test-move-docs";
    buildCommand = ''
      mkdir -p $out/{man,doc,info}
      touch $out/{man,doc,info}/foo
      cat $out/{man,doc,info}/foo

      _moveToShare

      (cat $out/share/{man,doc,info}/foo 2>/dev/null && echo "man,doc,info were moved") || (echo "man,doc,info were not moved" && exit 1)
    '';
  };
  move-lib64 = stdenv.mkDerivation {
    name = "test-move-lib64";
    buildCommand = ''
      mkdir -p $out/lib64
      touch $out/lib64/foo
      cat $out/lib64/foo

      _moveLib64

      # check symlink
      [[ -h $out/lib64 ]]
      ([[ -e $out/lib64 ]] && echo "symlink isn't broken") || (echo "symlink is broken" && exit 1)
      [[ -e $out/lib/foo ]]
    '';
  };
  move-sbin = stdenv.mkDerivation {
    name = "test-move-sbin";
    buildCommand = ''
      mkdir -p $out/sbin
      touch $out/sbin/foo
      cat $out/sbin/foo

      _moveSbin

      # check symlink
      [[ -h $out/sbin ]]
      ([[ -e $out/sbin ]] && echo "symlink isn't broken") || (echo "symlink is broken" && exit 1)
      [[ -e $out/bin/foo ]]
    '';
  };
  # TODO: add multiple-outputs
  patch-shebangs = import ./patch-shebangs.nix { inherit stdenv lib pkgs; };
  prune-libtool-files =
    let
      libFoo = pkgs.writeText "libFoo" ''
        # Generated by libtool (GNU libtool) 2.4.6
        old_library='''
        dependency_libs=' -Lbar.la -Lbaz.la'
      '';
    in
    stdenv.mkDerivation {
      name = "test-prune-libtool-files";
      buildCommand = ''
        mkdir -p $out/lib
        cp ${libFoo} $out/lib/libFoo.la
        _pruneLibtoolFiles
        grep "^dependency_libs=''' #pruned" $out/lib/libFoo.la
        # confirm file doesn't only contain the above
        grep "^old_library='''" $out/lib/libFoo.la
      '';
    };
  reproducible-builds = stdenv.mkDerivation {
    name = "test-reproducible-builds";
    buildCommand = ''
      # can't be tested more precisely because the value of random-seed changes depending on the output
      [[ $NIX_CFLAGS_COMPILE =~ "-frandom-seed=" ]]
      touch $out
    '';
  };
  set-source-date-epoch-to-latest = stdenv.mkDerivation {
    name = "test-set-source-date-epoch-to-latest";
    buildCommand = ''
      sourceRoot=$NIX_BUILD_TOP/source
      mkdir -p $sourceRoot
      touch --date=1/1/2015 $sourceRoot/foo

      _updateSourceDateEpochFromSourceRoot

      [[ $SOURCE_DATE_EPOCH == "1420070400" ]]
      touch $out
    '';
  };
  # TODO: add strip
}
