{
  lib,
  stdenv,
  fetchurl,
  extra-cmake-modules,
  shared-mime-info,
  wrapQtAppsHook,
  qtsvg,
  qtxmlpatterns,
  karchive,
  kconfig,
  kcoreaddons,
  kparts,
  kio,
  ki18n,
  kdiagram,
  kgraphviewer,
}:

stdenv.mkDerivation rec {
  pname = "massif-visualizer";
  version = "0.7.0";

  src = fetchurl {
    url = "mirror://kde/stable/massif-visualizer/${version}/src/${pname}-${version}.tar.xz";
    sha256 = "0v8z6r9gngzckvqyxjm9kp7hilwfqibyk2f9vag9l98ar0iwr97q";
  };

  patches = [ ./cmake-minimum-required.patch ];

  nativeBuildInputs = [
    extra-cmake-modules
    shared-mime-info
    wrapQtAppsHook
  ];

  buildInputs = [
    qtsvg
    qtxmlpatterns
    karchive
    kconfig
    kcoreaddons
    kparts
    kio
    ki18n
    kdiagram
    kgraphviewer
  ];

  meta = {
    description = "Tool that visualizes massif data generated by valgrind";
    mainProgram = "massif-visualizer";
    license = lib.licenses.gpl2;
    platforms = lib.platforms.linux;
    maintainers = with lib.maintainers; [ zraexy ];
  };
}
