{
  lib,
  buildPythonPackage,
  fetchPypi,
  httpx,
}:

buildPythonPackage rec {
  pname = "youtube-search-python";
  version = "1.6.6";
  format = "setuptools";

  src = fetchPypi {
    inherit pname version;
    hash = "sha256-RWjR12ns1+tLuDZfBO7G42TF9w7sezdl9UPa67E1/PU=";
  };

  patches = [ ./fix-httpx-proxies.patch ];

  propagatedBuildInputs = [ httpx ];

  pythonImportsCheck = [ "youtubesearchpython" ];

  # Project has no tests
  doCheck = false;

  meta = {
    description = "Search for YouTube videos, channels & playlists & get video information using link without YouTube Data API";
    homepage = "https://github.com/alexmercerind/youtube-search-python";
    license = lib.licenses.mit;
    maintainers = [ ];
  };
}
