{
  lib,
  buildPythonPackage,
  fetchFromGitHub,

  unittestCheckHook,

  hatchling,

  khanaa,
}:

buildPythonPackage rec {
  pname = "wunsen";
  version = "0.0.3";
  pyproject = true;

  src = fetchFromGitHub {
    owner = "cakimpei";
    repo = "wunsen";
    tag = "v${version}";
    hash = "sha256-lMEhtcWG+S3vAz+Y/qDxhaZslsO0pbs5xUn5QgZNs2U=";
  };

  build-system = [ hatchling ];

  dependencies = [ khanaa ];

  nativeCheckInputs = [ unittestCheckHook ];

  unittestFlagsArray = [
    "-s"
    "tests"
  ];

  pythonImportsCheck = [ "wunsen" ];

  meta = {
    description = "Transliterate/transcribe other languages into Thai Topics";
    homepage = "https://github.com/cakimpei/wunsen";
    changelog = "https://github.com/cakimpei/wunsen/releases/tag/v${version}";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [ vizid ];
  };
}
