#!/usr/bin/env nix-shell
#!nix-shell -i bash -p nix-prefetch-scripts

set -eou pipefail

version=$1

linux_cuda_version="cu128"
linux_bucket="https://download.pytorch.org/whl/${linux_cuda_version}"
cpu_bucket="https://download.pytorch.org/whl/cpu"

url_and_key_list=(
  "x86_64-linux-310 $linux_bucket/torchvision-${version}%2B${linux_cuda_version}-cp310-cp310-manylinux_2_28_x86_64.whl torchvision-${version}-cp310-cp310-linux_x86_64.whl"
  "x86_64-linux-311 $linux_bucket/torchvision-${version}%2B${linux_cuda_version}-cp311-cp311-manylinux_2_28_x86_64.whl torchvision-${version}-cp311-cp311-linux_x86_64.whl"
  "x86_64-linux-312 $linux_bucket/torchvision-${version}%2B${linux_cuda_version}-cp312-cp312-manylinux_2_28_x86_64.whl torchvision-${version}-cp312-cp312-linux_x86_64.whl"
  "x86_64-linux-313 $linux_bucket/torchvision-${version}%2B${linux_cuda_version}-cp313-cp313-manylinux_2_28_x86_64.whl torchvision-${version}-cp313-cp313-linux_x86_64.whl"
  "x86_64-linux-314 $linux_bucket/torchvision-${version}%2B${linux_cuda_version}-cp314-cp314-manylinux_2_28_x86_64.whl torchvision-${version}-cp314-cp314-linux_x86_64.whl"
  "aarch64-darwin-310 $cpu_bucket/torchvision-${version}-cp310-cp310-macosx_11_0_arm64.whl torchvision-${version}-cp310-cp310-macosx_11_0_arm64.whl"
  "aarch64-darwin-311 $cpu_bucket/torchvision-${version}-cp311-cp311-macosx_11_0_arm64.whl torchvision-${version}-cp311-cp311-macosx_11_0_arm64.whl"
  "aarch64-darwin-312 $cpu_bucket/torchvision-${version}-cp312-cp312-macosx_11_0_arm64.whl torchvision-${version}-cp312-cp312-macosx_11_0_arm64.whl"
  "aarch64-darwin-313 $cpu_bucket/torchvision-${version}-cp313-cp313-macosx_12_0_arm64.whl torchvision-${version}-cp313-cp313-macosx_12_0_arm64.whl"
  "aarch64-darwin-314 $cpu_bucket/torchvision-${version}-cp314-cp314-macosx_11_0_arm64.whl torchvision-${version}-cp314-cp314-macosx_11_0_arm64.whl"
  "aarch64-linux-310 $cpu_bucket/torchvision-${version}%2Bcpu-cp310-cp310-manylinux_2_28_aarch64.whl torchvision-${version}-cp310-cp310-linux_aarch64.whl"
  "aarch64-linux-311 $cpu_bucket/torchvision-${version}%2Bcpu-cp311-cp311-manylinux_2_28_aarch64.whl torchvision-${version}-cp311-cp311-linux_aarch64.whl"
  "aarch64-linux-312 $cpu_bucket/torchvision-${version}%2Bcpu-cp312-cp312-manylinux_2_28_aarch64.whl torchvision-${version}-cp312-cp312-linux_aarch64.whl"
  "aarch64-linux-313 $cpu_bucket/torchvision-${version}%2Bcpu-cp313-cp313-manylinux_2_28_aarch64.whl torchvision-${version}-cp313-cp313-linux_aarch64.whl"
  "aarch64-linux-314 $cpu_bucket/torchvision-${version}%2Bcpu-cp314-cp314-manylinux_2_28_aarch64.whl torchvision-${version}-cp314-cp314-linux_aarch64.whl"
)

hashfile="binary-hashes-$version.nix"
echo "  \"$version\" = {" >>$hashfile

for url_and_key in "${url_and_key_list[@]}"; do
  key=$(echo "$url_and_key" | cut -d' ' -f1)
  url=$(echo "$url_and_key" | cut -d' ' -f2)
  name=$(echo "$url_and_key" | cut -d' ' -f3)

  echo "prefetching ${url}..."
  hash=$(nix --extra-experimental-features nix-command hash convert --hash-algo sha256 $(nix-prefetch-url "$url" --name "$name"))

  echo "    $key = {" >>$hashfile
  echo "      name = \"$name\";" >>$hashfile
  echo "      url = \"$url\";" >>$hashfile
  echo "      hash = \"$hash\";" >>$hashfile
  echo "    };" >>$hashfile

  echo
done

echo "  };" >>$hashfile
echo "done."
