{
  lib,
  aiohttp,
  aioresponses,
  buildPythonPackage,
  dateparser,
  fetchFromGitHub,
  pycryptodome,
  pytest-asyncio,
  pytestCheckHook,
  requests-mock,
  requests,
  six,
  ujson,
  setuptools,
  websockets,
}:

buildPythonPackage rec {
  pname = "python-binance";
  version = "1.0.34";
  pyproject = true;

  src = fetchFromGitHub {
    owner = "sammchardy";
    repo = "python-binance";
    tag = "v${version}";
    hash = "sha256-afgEr82emFIiJGNrjGoU8MdiNKhZdn5B/LutmohE48M=";
  };

  build-system = [ setuptools ];

  dependencies = [
    aiohttp
    dateparser
    requests
    pycryptodome
    six
    ujson
    websockets
  ];

  nativeCheckInputs = [
    aioresponses
    pytest-asyncio
    pytestCheckHook
    requests-mock
  ];

  disabledTestPaths = [
    # Tests require network access
    "tests/test_api_request.py"
    "tests/test_async_client.py"
    "tests/test_async_client_futures.py"
    "tests/test_async_client_margin.py"
    "tests/test_async_client_options.py"
    "tests/test_async_client_portfolio.py"
    "tests/test_async_client_ws_api.py"
    "tests/test_async_client_ws_futures_requests.py"
    "tests/test_client.py"
    "tests/test_client_futures.py"
    "tests/test_client_gift_card.py"
    "tests/test_client_margin.py"
    "tests/test_client_options.py"
    "tests/test_client_portfolio.py"
    "tests/test_client_ws_api.py"
    "tests/test_client_ws_futures_requests.py"
    "tests/test_depth_cache.py"
    "tests/test_get_order_book.py"
    "tests/test_ping.py"
    "tests/test_reconnecting_websocket.py"
    "tests/test_socket_manager.py"
    "tests/test_streams.py"
    "tests/test_threaded_socket_manager.py"
    "tests/test_threaded_stream.py"
    "tests/test_ws_api.py"
    "tests/test_ids.py"
    "tests/test_headers.py"
    "tests/test_historical_klines.py"
    "tests/test_init.py"
    "tests/test_streams_options.py"
    "tests/test_cryptography.py"
    "tests/test_futures.py"
  ];

  pythonImportsCheck = [ "binance" ];

  meta = {
    description = "Binance Exchange API python implementation for automated trading";
    homepage = "https://github.com/sammchardy/python-binance";
    license = lib.licenses.mit;
  };
}
