{
  lib,
  buildPythonPackage,
  fetchFromGitHub,
  pip,
  pretend,
  pytestCheckHook,
  setuptools,
  virtualenv,
}:

buildPythonPackage rec {
  pname = "pip-api";
  version = "0.0.34";
  pyproject = true;

  src = fetchFromGitHub {
    owner = "di";
    repo = "pip-api";
    tag = version;
    hash = "sha256-nmCP4hp+BsD80OBjerOu+QTBBExGHvn/v19od4V3ncI=";
  };

  nativeBuildInputs = [ setuptools ];

  propagatedBuildInputs = [ pip ];

  nativeCheckInputs = [
    pretend
    pytestCheckHook
    virtualenv
  ];

  pythonImportsCheck = [ "pip_api" ];

  disabledTests = [
    "test_hash"
    "test_hash_default_algorithm_is_256"
    "test_installed_distributions"
    "test_invoke_install"
    "test_invoke_uninstall"
    "test_isolation"
  ];

  meta = {
    description = "Importable pip API";
    homepage = "https://github.com/di/pip-api";
    changelog = "https://github.com/di/pip-api/blob/${version}/CHANGELOG";
    license = with lib.licenses; [ mit ];
    maintainers = with lib.maintainers; [ fab ];
  };
}
