{
  lib,
  buildPythonPackage,
  colorclass,
  easygui,
  fetchFromGitHub,
  msoffcrypto-tool,
  olefile,
  pcodedmp,
  pyparsing,
  pytestCheckHook,
}:

buildPythonPackage rec {
  pname = "oletools";
  version = "0.60.2";
  format = "setuptools";

  src = fetchFromGitHub {
    owner = "decalage2";
    repo = "oletools";
    rev = "v${version}";
    hash = "sha256-ons1VeWStxUZw2CPpnX9p5I3Q7cMhi34JU8TeuUDt+Y=";
  };

  propagatedBuildInputs = [
    colorclass
    easygui
    msoffcrypto-tool
    olefile
    pcodedmp
    pyparsing
  ];

  nativeCheckInputs = [ pytestCheckHook ];

  postPatch = ''
    substituteInPlace setup.py \
      --replace "pyparsing>=2.1.0,<3" "pyparsing>=2.1.0"
  '';

  disabledTests = [
    # Test fails with AssertionError: Tuples differ: ('MS Word 2007+...
    "test_all"
    "test_xlm"
  ];

  pythonImportsCheck = [ "oletools" ];

  meta = {
    description = "Module to analyze MS OLE2 files and MS Office documents";
    homepage = "https://github.com/decalage2/oletools";
    license = with lib.licenses; [
      bsd2 # and
      mit
    ];
    maintainers = with lib.maintainers; [ fab ];
  };
}
