{
  lib,
  stdenv,
  buildPythonPackage,
  fetchPypi,
  setuptools,
  setuptools-scm,
  autoPatchelfHook,
  udev,
  pytestCheckHook,
}:

buildPythonPackage rec {
  pname = "libuuu";
  version = "1.5.243";
  pyproject = true;

  src = fetchPypi {
    inherit pname version;
    hash = "sha256-k7DFVrqkHzPLjZMdWyLdfawyOSw+L7Bi4oRdeJo6lxw=";
  };

  build-system = [
    setuptools
    setuptools-scm
  ];

  nativeBuildInputs = lib.optionals stdenv.hostPlatform.isLinux [
    autoPatchelfHook
  ];

  buildInputs = lib.optionals stdenv.hostPlatform.isLinux [
    udev
  ];

  pythonRelaxDeps = [
    "setuptools-scm"
  ];

  dependencies = [
    setuptools-scm
  ];

  pythonImportsCheck = [
    "libuuu"
  ];

  # Prevent tests to load the plugin from the source files instead of the installed ones
  preCheck = ''
    rm -rf libuuu
  '';

  nativeCheckInputs = [
    pytestCheckHook
  ];

  meta = {
    description = "Python wrapper for libuuu";
    homepage = "https://github.com/nxp-imx/mfgtools/tree/master/wrapper";
    license = lib.licenses.bsd3;
    maintainers = with lib.maintainers; [ GaetanLepage ];
  };
}
