{
  lib,
  attrs,
  buildPythonPackage,
  fetchFromGitHub,
  pytestCheckHook,
  pythonAtLeast,
  typish,
  tzdata,
}:

buildPythonPackage rec {
  pname = "jsons";
  version = "1.6.3";
  format = "setuptools";

  src = fetchFromGitHub {
    owner = "ramonhagenaars";
    repo = "jsons";
    tag = "v${version}";
    hash = "sha256-7OIByHvsqhKFOkb1q2kuxmbkkleryavYgp/T4U5hvGk=";
  };

  propagatedBuildInputs = [ typish ];

  nativeCheckInputs = [
    attrs
    pytestCheckHook
    tzdata
  ];

  disabledTestPaths = [
    # These tests are based on timings, which fail
    # on slow or overloaded machines.
    "tests/test_performance.py"
  ];

  disabledTests = lib.optionals (pythonAtLeast "3.11") [
    # https://github.com/ramonhagenaars/jsons/issues/187
    "test_dump_load_parameterized_collections"
  ];

  pythonImportsCheck = [ "jsons" ];

  meta = {
    description = "Turn Python objects into dicts or json strings and back";
    homepage = "https://github.com/ramonhagenaars/jsons";
    changelog = "https://github.com/ramonhagenaars/jsons/releases/tag/v${version}";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [ fmoda3 ];
  };
}
