{
  lib,
  stdenv,
  buildPythonPackage,
  fetchpatch,
  inkscape,
  poetry-core,
  cssselect,
  lxml,
  numpy,
  pillow,
  pygobject3,
  pyparsing,
  pyserial,
  scour,
  tinycss2,
  gobject-introspection,
  pytestCheckHook,
  gtk3,
}:

buildPythonPackage {
  pname = "inkex";
  inherit (inkscape) version;
  pyproject = true;

  inherit (inkscape) src;

  patches = [
    # Fix tests with newer libxml2
    # https://gitlab.com/inkscape/extensions/-/merge_requests/712
    (fetchpatch {
      url = "https://gitlab.com/inkscape/extensions/-/commit/b04ab718b400778a264f2085bbc779faebc08368.patch";
      hash = "sha256-BXRcfoeX7X8+x6CuKKBhrnzUHIwgnPay22Z8+rPZS54=";
      stripLen = 1;
      extraPrefix = "share/extensions/";
    })
  ];

  build-system = [ poetry-core ];

  pythonRelaxDeps = [
    "lxml"
    "numpy"
  ];

  dependencies = [
    cssselect
    lxml
    numpy
    pillow
    pygobject3
    pyparsing
    pyserial
    scour
    tinycss2
  ];

  pythonImportsCheck = [ "inkex" ];

  nativeCheckInputs = [
    gobject-introspection
    pytestCheckHook
  ];

  checkInputs = [
    gtk3
  ];

  disabledTests = [
    "test_extract_multiple"
    "test_lookup_and"
  ]
  ++ lib.optional stdenv.hostPlatform.isDarwin [
    "test_image_extract"
    "test_path_number_nodes"
    "test_plotter" # Hangs
  ];

  disabledTestPaths = [
    # Fatal Python error: Segmentation fault
    "tests/test_inkex_gui.py"
    "tests/test_inkex_gui_listview.py"
    "tests/test_inkex_gui_window.py"
    # Failed to find pixmap 'image-missing' in /build/source/tests/data/
    "tests/test_inkex_gui_pixmaps.py"
  ];

  postPatch = ''
    cd share/extensions

    substituteInPlace pyproject.toml \
      --replace-fail 'scour = "^0.37"' 'scour = ">=0.37"'
  '';

  meta = {
    description = "Library for manipulating SVG documents which is the basis for Inkscape extensions";
    homepage = "https://gitlab.com/inkscape/extensions";
    license = lib.licenses.gpl2Plus;
    maintainers = with lib.maintainers; [ dotlambda ];
  };
}
