{
  lib,
  anyio,
  buildPythonPackage,
  certifi,
  fetchFromGitHub,
  hatchling,
  hatch-fancy-pypi-readme,
  h11,
  h2,
  pytest-httpbin,
  pytest-trio,
  pytestCheckHook,
  socksio,
  trio,
  # for passthru.tests
  httpx,
  httpx-socks,
  respx,
}:

buildPythonPackage rec {
  pname = "httpcore";
  version = "1.0.9";
  pyproject = true;

  src = fetchFromGitHub {
    owner = "encode";
    repo = "httpcore";
    tag = version;
    hash = "sha256-YtAbx0iXN7u8pMBXQBUydvAH6ilH+veklvxSh5EVFXo=";
  };

  build-system = [
    hatchling
    hatch-fancy-pypi-readme
  ];

  dependencies = [
    certifi
    h11
  ];

  optional-dependencies = {
    asyncio = [ anyio ];
    http2 = [ h2 ];
    socks = [ socksio ];
    trio = [ trio ];
  };

  nativeCheckInputs = [
    pytest-httpbin
    pytest-trio
    pytestCheckHook
  ]
  ++ lib.concatAttrValues optional-dependencies;

  pythonImportsCheck = [ "httpcore" ];

  __darwinAllowLocalNetworking = true;

  passthru.tests = {
    inherit httpx httpx-socks respx;
  };

  meta = {
    changelog = "https://github.com/encode/httpcore/blob/${version}/CHANGELOG.md";
    description = "Minimal low-level HTTP client";
    homepage = "https://github.com/encode/httpcore";
    license = lib.licenses.bsd3;
    maintainers = with lib.maintainers; [ ris ];
  };
}
