{
  buildPythonPackage,
  cliff,
  sphinx,
  stestr,
  testscenarios,
}:

buildPythonPackage {
  pname = "cliff";
  inherit (cliff) version src;
  pyproject = false;

  postPatch = ''
    # only a small portion of the listed packages are actually needed for running the tests
    # so instead of removing them one by one remove everything
    rm test-requirements.txt
  '';

  dontBuild = true;
  dontInstall = true;

  nativeCheckInputs = [
    cliff
    sphinx
    stestr
    testscenarios
  ];

  checkPhase = ''
    stestr run
  '';
}
