{
  lib,
  appdirs,
  apsw,
  buildPythonPackage,
  cvss,
  fetchFromGitHub,
  httpx,
  msgpack,
  oras,
  orjson,
  packageurl-python,
  pydantic,
  pytest-cov-stub,
  pytestCheckHook,
  pyyaml,
  rich,
  semver,
  setuptools,
  tabulate,
  writableTmpDirAsHomeHook,
}:

buildPythonPackage (finalAttrs: {
  pname = "appthreat-vulnerability-db";
  version = "6.6.0";
  pyproject = true;

  src = fetchFromGitHub {
    owner = "AppThreat";
    repo = "vulnerability-db";
    tag = "v${finalAttrs.version}";
    hash = "sha256-/tcfHEvTdk0B/vfcqqkTn9kGT3QIPLWW4l01fjnrhqE=";
  };

  pythonRelaxDeps = [
    "msgpack"
    "semver"
  ];

  build-system = [ setuptools ];

  dependencies = [
    appdirs
    apsw
    cvss
    httpx
    msgpack
    orjson
    packageurl-python
    pydantic
    rich
    semver
    tabulate
  ]
  ++ httpx.optional-dependencies.http2
  ++ pydantic.optional-dependencies.email;

  optional-dependencies = {
    all = [
      oras
      pyyaml
    ];
    custom = [ pyyaml ];
    oras = [ oras ];
  };

  nativeCheckInputs = [
    pytest-cov-stub
    pytestCheckHook
    writableTmpDirAsHomeHook
  ]
  ++ lib.flatten (builtins.attrValues finalAttrs.passthru.optional-dependencies);

  disabledTests = [
    # Tests require network access
    "test_bulk_search"
    "test_download_recent"
    "test_parse_purl"
  ];

  pythonImportsCheck = [ "vdb" ];

  meta = {
    description = "Vulnerability database and package search for sources such as OSV, NVD, GitHub and npm";
    homepage = "https://github.com/appthreat/vulnerability-db";
    changelog = "https://github.com/AppThreat/vulnerability-db/releases/tag/${finalAttrs.src.tag}";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [ fab ];
    mainProgram = "vdb";
  };
})
