{
  lib,
  ocaml,
  buildDunePackage,
  fetchurl,
  num,
  lutils,
  ounit,
}:

buildDunePackage rec {
  pname = "rdbg";
  version = "1.199.0";

  env =
    # Fix build with gcc15
    lib.optionalAttrs
      (
        lib.versionAtLeast ocaml.version "4.10" && lib.versionOlder ocaml.version "4.14"
        || lib.versions.majorMinor ocaml.version == "5.0"
      )
      {
        NIX_CFLAGS_COMPILE = "-std=gnu11";
      };

  src = fetchurl {
    url = "http://www-verimag.imag.fr/DIST-TOOLS/SYNCHRONE/pool/rdbg.v${version}.tgz";
    hash = "sha512:6076eaa3608a313f8ac71a4f5aa4fcc64aeb0c646d581e5035110d4c80f94de34f2ba26f90a9a1e92a7f788c9e799f1f7b0e3728c853a21983ad732f0ee60352";
  };

  buildInputs = [
    num
    ounit
  ];

  propagatedBuildInputs = [
    lutils
  ];

  meta = {
    homepage = "https://gricad-gitlab.univ-grenoble-alpes.fr/verimag/synchrone/rdbg";
    description = "Programmable debugger that targets reactive programs for which a rdbg-plugin exists. Currently two plugins exist : one for Lustre, and one for Lutin (nb: both are synchronous programming languages)";
    license = lib.licenses.cecill21;
    maintainers = [ lib.maintainers.delta ];
  };
}
